const hre = require("hardhat");

async function main() {
    const blockContract = await hre.ethers.getContractFactory("BlockInfo");
    const contract = await blockContract.deploy();
    await contract.waitForDeployment();
    const contractAddr = await contract.getAddress();
    console.log("BlockInfo Contract deployed at:", contractAddr);

    // setBlockInfo
    const tx = await contract.setBlockInfo();
    await tx.wait();
    console.log("Block info set.");

    // getBlockInfo
    const info = await contract.getBlockInfo();
    const [blockheight, blocktime] = info;
    console.log("Retrieved Block Info:", blockheight.toString(), blocktime.toString());
    let rpcBlockHeader = await hre.ethers.provider.getBlock(blockheight);
    if (blocktime != rpcBlockHeader.timestamp) {
        console.error("Block time mismatch!", blocktime.toString(), rpcBlockHeader.timestamp.toString());
    } else {
        console.log("Block time matches.");
    }
    console.log("RPC Block Info:", rpcBlockHeader.number.toString(), rpcBlockHeader.timestamp.toString());

}

main().catch((error) => {
    console.error(error);
    process.exitCode = 1;
});