const { ContractFactory } = require("ethers");
const hre = require("hardhat");


async function test() {
    const signer = new hre.ethers.Wallet(process.env.DEPLOY_PRIVATE_KEY, hre.ethers.provider);
    const transferAmount = hre.ethers.parseEther("0.0001");
    const chainId = await hre.ethers.provider.getNetwork().then(network => network.chainId);

    var nonce = await hre.ethers.provider.getTransactionCount(signer.address)
    const signedTx = await signer.signTransaction({
        type: 0,
        chainId: chainId,
        nonce: nonce,
        to: "0x6ddb3A03366e218956483A840D8BfB490ADE1beB",
        data: '',
        value: transferAmount,
        gasLimit: 1000000,
        gasPrice: hre.ethers.parseUnits("1", "gwei"),
    });

    // 发送交易
    const txResponse = await hre.ethers.provider.broadcastTransaction(signedTx);
    // wait receipt
    await txResponse.wait();
    const receipt = await hre.ethers.provider.getTransactionReceipt(txResponse.hash);
    console.log("Transaction receipt:", receipt.blockNumber);
}

// Define the script
async function main() {
    await test()
}

// Run the script
main().catch((error) => {
    console.error("Error:", error);
});