// Compatible with OpenZeppelin Contracts ^5.0.0
pragma solidity ^0.8.26;

import  "@openzeppelin/contracts/utils/ReentrancyGuardTransient.sol";

contract TTest is ReentrancyGuardTransient{

    function testBASEFEE() public view returns(uint256) {
        return block.basefee;
    }

    function testPREVRANDAO() public view returns(uint256) {
        return block.prevrandao;
    }

    function testBLOBHASH() public view returns (bytes32) {
        return blobhash(1);
    }

    function testBLOBFEE() public view returns(uint256) {
        return block.blobbasefee;
    }

    event Call(uint256);

    function test() nonReentrant public {
        emit Call(1);
        (bool success, ) = address(msg.sender).call{gas: 250000}("");
        require(success, "rvt");
    }

}