const { ContractFactory } = require("ethers");
const hre = require("hardhat");

let initialValidators = process.env.BRIDGE_VALIDATORS

async function addValidators(contract, validators) {
    let validatorList = validators.split(',')
    for (let i = 0; i < validatorList.length; i++) {
        var tx = await contract.addValidator(validatorList[i])
        await tx.wait();
        console.log("Added validator:", validatorList[i]);
    }
}

// Define the script
async function deployAtSourceChain() {
    // Deploy the contract
    const factory =  await hre.ethers.getContractFactory(
        "Bridge"
    );
    const contract = await factory.deploy();
    await contract.waitForDeployment();
    const depAddr = await contract.getAddress();
    console.log("Contract deployed for source at:", depAddr);
    await initForSourceChain(contract);
}

async function initForSourceChain(bridge) {
    // add validator
    await addValidators(bridge, initialValidators);
    // set
}

async function deployAtMovaChain() {
    // Deploy the contract
    const factory =  await hre.ethers.getContractFactory(
        "Bridge"
    );
    const contract = await factory.deploy();
    await contract.waitForDeployment();
    const depAddr = await contract.getAddress();
    console.log("Contract deployed for mova at:", depAddr);
    await initForMovaChain(contract);

}
async function initForMovaChain(bridge) {
    await addValidators(bridge, initialValidators);
}

// Define the script
async function main() {
    await deployAtSourceChain();
    await deployAtMovaChain();
}

// Run the script
main().catch((error) => {
    console.error("Error:", error);
});