const { ContractFactory } = require("ethers");
const hre = require("hardhat");


async function test() {
    const signer = new hre.ethers.Wallet(process.env.DEPLOY_PRIVATE_KEY, hre.ethers.provider);
    const transferAmount = hre.ethers.parseEther("0.0001");

    var nonce = await hre.ethers.provider.getTransactionCount(signer.address)
    nonce = nonce + 1
    const signedTx = await signer.signTransaction({
        type: 0,
        chainId: 10323,
        nonce: nonce,
        to: "0x88395111AB1586a4030dAC62a183542762929bbC", // first
        // to: "0x6ddb3A03366e218956483A840D8BfB490ADE1beB", // second
        data: '',
        value: transferAmount,
        gasLimit: 1000000,
        gasPrice: hre.ethers.parseUnits("4", "gwei"),
    });

    // 发送交易
    const txResponse = await hre.ethers.provider.broadcastTransaction(signedTx);
    console.log("Transaction sent:", txResponse.hash);
}

// Define the script
async function main() {
    await test()
}

// Run the script
main().catch((error) => {
    console.error("Error:", error);
});