const { ContractFactory } = require("ethers");
const hre = require("hardhat");

// Define the script
async function main() {
    // Deploy the contract
    const factory =  await hre.ethers.getContractFactory(
        "RevertContract"
    );
    const contract = await factory.deploy();
    await contract.waitForDeployment();
    const depAddr = await contract.getAddress();
    console.log("Contract deployed at:", depAddr);

    // sendViaTransfer
    const recipient = "0xa686b69111eaDc74d45eEB3bE4aE487Fd61497E6"; // Replace with the recipient's address
    const transferAmount = ethers.parseEther("0.0005"); // 0.0005 ETH

    const viaTransfer = await contract.sendViaTransfer(recipient, transferAmount, {value: transferAmount, gas: 1000000, gasPrice: 1000000000});
    await viaTransfer.wait();
    console.log(`Transferred ${ethers.formatEther(transferAmount)} ETH to ${recipient} via transfer`);

    // sendViaCall
    const viaCall = await contract.sendViaCall(recipient, transferAmount, {value: transferAmount});
    await viaCall.wait();
    console.log(`Transferred ${ethers.formatEther(transferAmount)} ETH to ${recipient} via call`);

    // sendViaSend
    const viaSend = await contract.sendViaSend(recipient, transferAmount, {value: transferAmount});
    await viaSend.wait();
    console.log(`Transferred ${ethers.formatEther(transferAmount)} ETH to ${recipient} via send`);
}

// Run the script
main().catch((error) => {
    console.error("Error:", error);
});