const {
  loadFixture,
} = require("@nomicfoundation/hardhat-toolbox/network-helpers");
const { expect } = require("chai");

describe("TestMCOPY", function () {
  async function deployTestMCOPYFixture() {
    const TestMCOPY = await ethers.getContractFactory("TestMCOPY");
    const testMCOPY = await TestMCOPY.deploy();
    return { testMCOPY };
  }

  describe("Deployment", function () {
    it("Should deploy successfully", async function () {
      const { testMCOPY } = await loadFixture(deployTestMCOPYFixture);
      expect(testMCOPY.target).to.not.be.null;
    });
  });

  describe("Opcodes", function () {
    it("Should correctly perform mcopy", async function () {
      const { testMCOPY } = await loadFixture(deployTestMCOPYFixture);
      const result = await testMCOPY.testExplicitMCopy();
      expect(result).to.equal("0xdeadbeefdeadbeefdeadbeefdeadbeefdeadbeefdeadbeefdeadbeefdeadbeef");
    });
  });
});
