// SPDX-License-Identifier: MIT
pragma solidity ^0.8.10;

contract RevertContract {
    event log(string message);
    modifier minimumEther(uint256 _amount) {
        require(_amount >= 1*10**18, "minimum 1 ether");
        _;
    }
    function sendViaTransfer(address payable _to, uint256 _amount) public payable minimumEther(_amount) {
        require(_amount >= 1*10**18, "minimum 1 ether");
        _to.transfer(_amount);
    }

    function sendViaSend(address payable _to, uint256 _amount) public payable minimumEther(_amount) returns (bool) {
        emit log("sendViaSend");
        bool sent = _to.send(_amount);
        require(sent, "Send failed");
        return sent;
    }

    function sendViaCall(address payable _to, uint256 _amount) public payable minimumEther(_amount) returns (bool) {
        emit log("sendViaCall");
        (bool success, ) = _to.call{value: _amount}("");
        require(success, "Call failed");
        return success;
    }
    receive() external payable {}
}