const { expect } = require("chai");
const { ethers } = require("hardhat");

describe("RevertContract", function () {
    let RevertContract, revertContract, owner, recipient;

    beforeEach(async function () {
        // Deploy the contract
        [owner] = await ethers.getSigners();
        recipient = '0xa686b69111eaDc74d45eEB3bE4aE487Fd61497E6'; // Replace with a valid recipient address
        const RevertContractFactory = await ethers.getContractFactory("RevertContract");
        revertContract = await RevertContractFactory.deploy();
        await revertContract.waitForDeployment();
    });

    it("should revert sendViaTransfer if amount is less than 1 ether", async function () {
        const transferAmount = ethers.parseEther("0.5"); // Less than 1 ether
        await expect(
            revertContract.sendViaTransfer(recipient, transferAmount, { value: transferAmount })
        ).to.be.revertedWith("minimum 1 ether");
    });

    it("should successfully send via transfer if amount is 1 ether or more", async function () {
        const transferAmount = ethers.parseEther("1"); // Exactly 1 ether
        await expect(
            revertContract.sendViaTransfer(recipient, transferAmount, { value: transferAmount })
        ).to.not.be.reverted;
    });

    it("should revert sendViaSend if amount is less than 1 ether", async function () {
        const sendAmount = ethers.parseEther("0.5"); // Less than 1 ether
        await expect(
            revertContract.sendViaSend(recipient, sendAmount, { value: sendAmount })
        ).to.be.revertedWith("minimum 1 ether");
    });

    it("should successfully send via send if amount is 1 ether or more", async function () {
        const sendAmount = ethers.parseEther("1"); // Exactly 1 ether
        await expect(
            revertContract.sendViaSend(recipient, sendAmount, { value: sendAmount })
        ).to.not.be.reverted;
    });

    it("should revert sendViaCall if amount is less than 1 ether", async function () {
        const callAmount = ethers.parseEther("0.5"); // Less than 1 ether
        await expect(
            revertContract.sendViaCall(recipient, callAmount, { value: callAmount })
        ).to.be.revertedWith("minimum 1 ether");
    });

    it("should successfully send via call if amount is 1 ether or more", async function () {
        const callAmount = ethers.parseEther("1"); // Exactly 1 ether
        await expect(
            revertContract.sendViaCall(recipient, callAmount, { value: callAmount })
        ).to.not.be.reverted;
    });
});