const { ContractFactory } = require("ethers");
const hre = require("hardhat");


async function test() {
    const signer = new hre.ethers.Wallet(process.env.DEPLOY_PRIVATE_KEY, hre.ethers.provider);
    const chainId = await hre.ethers.provider.getNetwork().then(network => network.chainId);

    const TestMCOPY = await ethers.getContractFactory("TestMCOPY");
    testMCOPY = await TestMCOPY.deploy();
    await testMCOPY.waitForDeployment();
    console.log("Deployed TestMCOPY at address:", testMCOPY.target);

    console.log("Calling TestMCOPY.testExplicitMCopy()");
    const result = await testMCOPY.testExplicitMCopy();
    console.log("Result:", result);

    const TTest = await ethers.getContractFactory("TTest");
    ttest = await TTest.deploy();
    await ttest.waitForDeployment();
    console.log("Deployed TTest at address:", ttest.target);

    console.log("Calling TTest.testBASEFEE()");
    const basefee = await ttest.testBASEFEE();
    console.log("Result:", basefee.toString());

    console.log("Calling TTest.testPREVRANDAO()");
    const prevrandao = await ttest.testPREVRANDAO();
    console.log("Result:", prevrandao.toString());

    try {
        console.log("Calling TTest.testBLOBHASH()");
        const blobhash = await ttest.testBLOBHASH();
        console.log("Result:", blobhash);
    } catch (error) {
        console.error("Error calling testBLOBHASH:", error.message);
    }

    console.log("Calling TTest.testBLOBFEE()");
    const blobfee = await ttest.testBLOBFEE();
    console.log("Result:", blobfee.toString());

    try {
        console.log("Calling TTest.test()");
        const tx = await ttest.test();
        await tx.wait();
        console.log("TTest.test() called successfully");
    } catch (error) {
        console.error("Error calling test:", error.message);
    }
}

// Define the script
async function main() {
    await test()
}

// Run the script
main().catch((error) => {
    console.error("Error:", error);
});