const { ContractFactory, ethers} = require("ethers");
const hre = require("hardhat");

// Define the script
async function main() {
    const factoryAddress = '0xedd8Da22D948f3F594FdC37840d961461814EeA3'
    const bytecode = await hre.ethers.provider.getCode(factoryAddress)
    const codeHash = hre.ethers.keccak256(bytecode);
    console.log('Factory Code Hash:', codeHash);
}

// Run the script
main().catch((error) => {
    console.error("Error:", error);
});