const { ContractFactory } = require("ethers");
const hre = require("hardhat");

var addrlist = [
    "0xaccf7aacd00bb765120f10685e58d916d3ec3057",
    "0x4631638617F6CF476BeC1AA9A892D308AaE2062A",
    "0x43Fa8B58AaBeF30bE4221C7c435Fa38d34f0ccb1",
    "0x193b7fBA150679AC96c675964180dA078B73fE3c",
    "0x5b89a423416B00769ecB9F148411CD686d165A43",
    "0xDF2cf3eE3E4E36490F5f942372fF4c975040bBd0",
    "0xdD9720aBe15CD07cc2BF9213C1f08CFf1AE0b37D",
    "0xD7FB4128F5451f88A5e525ef5303d714633435A7",
    "0xf5c5C8cC784C8183316f4d1f0E50c46DF45920c8",
    "0x9923f67774A4250bf2B2eA34Da9cBbc6aBd98caD",
    "0xe40701772cCBA7a515CE557c3eaeB4B29B92C71e"
]

async function test() {
    const transferAmount = hre.ethers.parseEther("100000");
    const signer = new hre.ethers.Wallet(process.env.DEPLOY_PRIVATE_KEY, hre.ethers.provider);

    const chainId = await hre.ethers.provider.getNetwork().then(network => network.chainId);

    var nonce = await hre.ethers.provider.getTransactionCount(signer.address)
    for (let i = 0; i < addrlist.length; i++) {
        const signedTx = await signer.signTransaction({
            type: 0,
            chainId: chainId,
            nonce: nonce + i,
            to: addrlist[i],
            data: '',
            value: transferAmount,
            gasLimit: 210000,
            gasPrice: hre.ethers.parseUnits("1", "gwei"),
        });

        // 发送交易
        const txResponse = await hre.ethers.provider.broadcastTransaction(signedTx);
        console.log("Transaction sent to:", addrlist[i], " tx hash:", txResponse.hash);
    }


    console.log("All transactions sent.");
}

// Define the script
async function main() {
    await test()
}

// Run the script
main().catch((error) => {
    console.error("Error:", error);
});