const hre = require("hardhat");

async function coinBalance(userlist) {
    let height = await hre.ethers.provider.getBlockNumber();
    console.log(`Current block height: ${height}`);
    for (let i = 0; i < userlist.length; i++) {
        let user = userlist[i];
        let balance = await hre.ethers.provider.getBalance(user);
        console.log(`MOVA balance of ${user}: ${hre.ethers.formatEther(balance)} ETH`);
    }
}

async function tokenBalance(tokenAddr, userlist) {
    const tokenContract = await hre.ethers.getContractAt("PublicToken", tokenAddr);
    for (let i = 0; i < userlist.length; i++) {
        let user = userlist[i];
        let balance = await tokenContract.balanceOf(user);
        console.log(`Token balance of ${user}: ${hre.ethers.formatEther(balance)} tokens`);
    }
}

async function deployToken() {
    const tokenFactory = await hre.ethers.getContractFactory(
        "PublicToken"
    );
    const tokenContract = await tokenFactory.deploy();
    await tokenContract.waitForDeployment();
    const tokenAddr = await tokenContract.getAddress();
    console.log("Token Contract deployed at:", tokenAddr);
    return tokenAddr;
}

async function sendCoin(to, nonce) {
    const signer = new hre.ethers.Wallet(process.env.DEPLOY_PRIVATE_KEY, hre.ethers.provider);
    const transferAmount = hre.ethers.parseEther("0.0001");
    const chainId = await hre.ethers.provider.getNetwork().then(network => network.chainId);
    const signedTx = await signer.signTransaction({
        type: 0,
        chainId: chainId,
        nonce: nonce,
        to: to,
        data: '',
        value: transferAmount,
        gasLimit: 1000000,
        gasPrice: hre.ethers.parseUnits("1", "gwei"),
    });

    // 发送交易
    const txResponse = await hre.ethers.provider.broadcastTransaction(signedTx);
    console.log("Transaction coin sent:", txResponse.hash);
}

async function sendToken(tokenContract, to, amount, nonce) {
    const signer = new hre.ethers.Wallet(process.env.DEPLOY_PRIVATE_KEY, hre.ethers.provider);
    const chainid = await hre.ethers.provider.getNetwork().then(network => network.chainId);


    // Encode the function call
    const abi = [
        "function mint(address to, uint256 amount) external"
    ];
    const iface = new hre.ethers.Interface(abi);
    const data = iface.encodeFunctionData("mint", [to, amount]);

    // 签名交易
    const signedTx = await signer.signTransaction({
        type: 0,
        chainId: chainid,
        nonce: nonce,
        to: tokenContract,
        data: data,
        value: 0,
        gasLimit: 1000000, // 设置 gas 限制
        gasPrice: hre.ethers.parseUnits("1", "gwei"),
    });

    // 发送交易
    const txResponse = await hre.ethers.provider.broadcastTransaction(signedTx);
    console.log("Transaction token sent:", txResponse.hash);
}

// Define the script
async function main() {
    const tokenFactory = await hre.ethers.getContractFactory(
        "PublicToken"
    );
    const tokenContract = await tokenFactory.deploy();
    await tokenContract.waitForDeployment();
    const tokenAddr = await tokenContract.getAddress();
    console.log("Token Contract deployed at:", tokenAddr);
    // loop transfer token and eth to multiple users
    const accounts = await hre.ethers.getSigners();
    const sender = accounts[0];
    const users = [
        '0xF26B752d804F14f863462f310e0b01B38fFD414e',
        '0x6ddb3A03366e218956483A840D8BfB490ADE1beB',
        '0x9a0782a52460B7ac7f0FbEc3756BFD58eD63C2a3'
    ];
    let sendernonce = await hre.ethers.provider.getTransactionCount(sender.address);

    for (let i = 0; i < 10000; i++) {
        let idx = i % users.length;
        let user = users[idx];
        // build tx with all param and sign tx with sender private key
        // transfer 0.05 MOVA to user
        await sendCoin(user, sendernonce);
        sendernonce+=1;
        await sendToken(tokenAddr, user, hre.ethers.parseEther("100.0"), sendernonce);
        sendernonce +=1;
        // sleep 1s.
        await new Promise(resolve => setTimeout(resolve, 1000));
    }
    // await coinBalance(['0x9a0782a52460B7ac7f0FbEc3756BFD58eD63C2a3','0x6ddb3A03366e218956483A840D8BfB490ADE1beB'])
    // await tokenBalance('0x57B84A31E00eF4378E6b2D30703b73d02Aee13f8', ['0xF26B752d804F14f863462f310e0b01B38fFD414e'])
}
// Run the script
main().catch((error) => {
    console.error("Error:", error);
});