use tidb_block_browser_user;
/*
 Navicat Premium Data Transfer

 Source Server         : wuban-test-server
 Source Server Type    : MySQL
 Source Server Version : 80031 (8.0.31)
 Source Host           : 54.72.101.87:50036
 Source Schema         : tidb_block_browser_user

 Target Server Type    : MySQL
 Target Server Version : 80031 (8.0.31)
 File Encoding         : 65001

 Date: 28/02/2023 14:52:13
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for tb_name_address_tag
-- ----------------------------
DROP TABLE IF EXISTS `tb_name_address_tag`;
CREATE TABLE `tb_name_address_tag` (
  `id` bigint NOT NULL,
  `user_name` varchar(100) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '用户名',
  `email` varchar(300) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '用户邮箱',
  `company_name` varchar(300) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '公司名',
  `company_website` varchar(300) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '公司主页',
  `user_role` int DEFAULT '0' COMMENT '用户角色 1-地址拥有者 2-普通用户',
  `project_website` varchar(300) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '项目主页',
  `addresses` longtext COLLATE utf8mb4_bin COMMENT '请求验证备注信息的地址列表',
  `comment` longtext COLLATE utf8mb4_bin COMMENT '补充备注',
  `verified` int DEFAULT '0' COMMENT '是否通过人工验证,0未验证1已通过',
  `reject_reason` longtext COLLATE utf8mb4_bin COMMENT '拒绝理由',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除 2-已拒绝',
  `create_time` timestamp DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='用户请求认证地址公共备注表';

-- ----------------------------
-- Table structure for tb_user
-- ----------------------------
DROP TABLE IF EXISTS `tb_user`;
CREATE TABLE `tb_user` (
  `id` bigint NOT NULL,
  `user_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '用户名',
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '密码',
  `salt` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '盐值',
  `jwt_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT 'token',
  `type` int DEFAULT NULL COMMENT '类型 1-手机注册',
  `mobile_phone` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '手机号',
  `email` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '电子邮箱',
  `nick_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '昵称',
  `real_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '真实姓名',
  `head_portrait` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '头像',
  `status` int DEFAULT '1' COMMENT '状态,1：正常',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `create_time` timestamp DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `login_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '登录ip',
  `login_time` timestamp DEFAULT NULL COMMENT '登录时间',
  `public_profile_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '公共资料名称',
  `public_profile_picture` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '公共资料图片地址',
  `public_profile_picture_type` tinyint unsigned DEFAULT '3' COMMENT '公共资料图片类型,1-系统，2-锁定，3-上传',
  `public_profile_bio` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin COMMENT '公共资料简介',
  `profile_website` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '个人资料网站',
  `newsletter` int DEFAULT '0' COMMENT '是否发送营销邮件',
  `ignore_poor_reputation` int DEFAULT '0' COMMENT '忽略信誉差的token',
  `is_admin` int DEFAULT '0' COMMENT '管理员用户',
  `is_activated` int DEFAULT '0' COMMENT '是否激活 0否1是',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='用户信息表';

-- ----------------------------
-- Table structure for tb_user_address_note
-- ----------------------------
DROP TABLE IF EXISTS `tb_user_address_note`;
CREATE TABLE `tb_user_address_note` (
  `id` bigint NOT NULL,
  `user_id` bigint DEFAULT NULL COMMENT '用户ID',
  `address` varchar(42) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '地址',
  `tag` varchar(35) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '地址标签',
  `note` varchar(500) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '地址备注',
  `is_favorite` int DEFAULT '0' COMMENT '是否标记为喜欢,0否1是',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `create_time` timestamp DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id_idx` (`user_id`) USING BTREE,
  KEY `address_idx` (`address`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='用户地址备注表';

-- ----------------------------
-- Table structure for tb_user_api_key
-- ----------------------------
DROP TABLE IF EXISTS `tb_user_api_key`;
CREATE TABLE `tb_user_api_key` (
  `id` bigint NOT NULL,
  `user_id` bigint unsigned DEFAULT '0' COMMENT '用户ID',
  `app_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '键值名称',
  `app_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '公钥',
  `app_secret` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '私钥',
  `remarks` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '备注信息',
  `status` tinyint unsigned DEFAULT '1' COMMENT '状态,0-冻结,1-正常 ',
  `is_deleted` tinyint unsigned DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `create_time` timestamp DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id_index` (`user_id`),
  KEY `app_name_index` (`app_name`),
  KEY `app_key_index` (`app_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='用户apiKey';

-- ----------------------------
-- Table structure for tb_user_custom_abi
-- ----------------------------
DROP TABLE IF EXISTS `tb_user_custom_abi`;
CREATE TABLE `tb_user_custom_abi` (
  `id` bigint NOT NULL,
  `user_id` bigint DEFAULT NULL COMMENT '用户ID',
  `name` varchar(100) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '自定义名称',
  `contract_address` varchar(42) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '合约地址',
  `abi` longtext COLLATE utf8mb4_bin COMMENT '合约JSON ABI',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `create_time` timestamp DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id_idx` (`user_id`) USING BTREE,
  KEY `contract_address_idx` (`contract_address`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='用户自定义合约ABI表';

-- ----------------------------
-- Table structure for tb_user_token_ignore
-- ----------------------------
DROP TABLE IF EXISTS `tb_user_token_ignore`;
CREATE TABLE `tb_user_token_ignore` (
  `id` bigint NOT NULL,
  `user_id` bigint DEFAULT NULL COMMENT '用户ID',
  `token` varchar(42) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'token地址',
  `note` varchar(155) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '备注信息',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `create_time` timestamp DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id_idx` (`user_id`) USING BTREE,
  KEY `token_idx` (`token`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='用户忽略token表';

-- ----------------------------
-- Table structure for tb_user_txn_note
-- ----------------------------
DROP TABLE IF EXISTS `tb_user_txn_note`;
CREATE TABLE `tb_user_txn_note` (
  `id` bigint NOT NULL,
  `user_id` bigint DEFAULT NULL COMMENT '用户ID',
  `tx_hash` varchar(66) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '交易hash',
  `note` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '交易备注',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `create_time` timestamp DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id_idx` (`user_id`) USING BTREE,
  KEY `tx_hash_idx` (`tx_hash`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='用户交易备注表';

-- ----------------------------
-- Table structure for tb_user_verified_address
-- ----------------------------
DROP TABLE IF EXISTS `tb_user_verified_address`;
CREATE TABLE `tb_user_verified_address` (
  `id` bigint NOT NULL,
  `user_id` bigint DEFAULT NULL COMMENT '用户ID',
  `contract_address` varchar(42) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '合约地址',
  `contract_creator` varchar(42) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '合约创建地址',
  `message` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '签名消息',
  `message_hash` varchar(64) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '签名消息kecc2k256 hash',
  `signature` varchar(134) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '签名结果',
  `verified` int DEFAULT '0' COMMENT '是否验证,0-未验证,1-已验证',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `create_time` timestamp DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id_idx` (`user_id`) USING BTREE,
  KEY `contract_address_idx` (`contract_address`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='用户验证合约owner表';

-- ----------------------------
-- Table structure for tb_user_verified_address_info
-- ----------------------------
DROP TABLE IF EXISTS `tb_user_verified_address_info`;
CREATE TABLE `tb_user_verified_address_info` (
  `id` bigint NOT NULL,
  `user_id` bigint DEFAULT NULL COMMENT '用户ID',
  `contract_address` varchar(42) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '合约地址',
  `request_type` int DEFAULT '0' COMMENT '请求类型 1-新发行 2-更新 3-迁移',
  `message` longtext COLLATE utf8mb4_bin COMMENT '请求信息',
  `basic_info` longtext COLLATE utf8mb4_bin COMMENT '基本信息',
  `social_profiles` longtext COLLATE utf8mb4_bin COMMENT '社交信息',
  `price_data` longtext COLLATE utf8mb4_bin COMMENT '价格信息',
  `others` longtext COLLATE utf8mb4_bin COMMENT '其他信息(私募公募,销毁等)',
  `verified` int DEFAULT '0' COMMENT '是否通过人工验证,0未验证 1已通过 2已拒绝',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `create_time` timestamp DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `reject_reason` longtext COLLATE utf8mb4_bin COMMENT '拒绝理由',
  PRIMARY KEY (`id`),
  KEY `user_id_idx` (`user_id`) USING BTREE,
  KEY `contract_address_idx` (`contract_address`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='token信息更新申请表';

-- ----------------------------
-- Table structure for tb_user_watch_list
-- ----------------------------
DROP TABLE IF EXISTS `tb_user_watch_list`;
CREATE TABLE `tb_user_watch_list` (
  `id` bigint NOT NULL,
  `user_id` bigint DEFAULT NULL COMMENT '用户ID',
  `address` varchar(42) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '地址',
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '地址说明',
  `notification_type` int DEFAULT '0' COMMENT '通知类型,0不通知,1只收款,2只转出,3全部',
  `track_crc20` int DEFAULT '0' COMMENT '是否跟踪CRC20,0不跟踪,1跟踪',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `create_time` timestamp DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id_idx` (`user_id`) USING BTREE,
  KEY `address_idx` (`address`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='地址监控表';


SET FOREIGN_KEY_CHECKS = 1;
