use tidb_block_browser;
/*
 Navicat Premium Data Transfer

 Source Server         : wuban-test-server
 Source Server Type    : MySQL
 Source Server Version : 80031 (8.0.31)
 Source Host           : 13.41.9.135:3306
 Source Schema         : tidb_block_browser

 Target Server Type    : MySQL
 Target Server Version : 80031 (8.0.31)
 File Encoding         : 65001

 Date: 09/08/2023 14:32
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for tb_account_info
-- ----------------------------
DROP TABLE IF EXISTS `tb_account_info`;
CREATE TABLE `tb_account_info` (
  `id` bigint NOT NULL,
  `block_id` bigint DEFAULT NULL COMMENT '区块号',
  `block_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '区块hash',
  `tx_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '交易hash',
  `account_address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '账户地址',
  `account_type` int DEFAULT NULL COMMENT '账户类型：1-account 2-contract',
  `my_name_tag` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'My Name Tag',
  `balance` decimal(64,18) DEFAULT NULL COMMENT '余额',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_unique_index` (`account_address`),
  KEY `block_id_index` (`block_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='账户信息表';

-- ----------------------------
-- Table structure for tb_account_stats
-- ----------------------------
DROP TABLE IF EXISTS `tb_account_stats`;
CREATE TABLE `tb_account_stats` (
  `id` bigint NOT NULL,
  `stats_date` varchar(10) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '日期',
  `account_address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '账户地址',
  `account_type` int DEFAULT NULL COMMENT '账户类型：1-account 2-contract',
  `last_block` bigint DEFAULT NULL COMMENT '最大区块号',
  `ht_balance` decimal(64,18) DEFAULT '0.000000000000000000' COMMENT 'Ht余额',
  `txn_count` bigint DEFAULT '0' COMMENT '交易数量',
  `txn_count_from` bigint DEFAULT '0' COMMENT '发送交易数量',
  `txn_count_to` bigint DEFAULT '0' COMMENT '接收交易数量',
  `txn_amount` decimal(64,18) DEFAULT NULL COMMENT '交易总额',
  `txn_amount_from` decimal(64,18) DEFAULT NULL COMMENT '发送交易总额',
  `txn_amount_to` decimal(64,18) DEFAULT NULL COMMENT '接收交易总额',
  `fees_spent` decimal(64,18) DEFAULT '0.000000000000000000' COMMENT '发送手续费',
  `fees_used` decimal(64,18) DEFAULT '0.000000000000000000' COMMENT '接受手续费',
  `token_num` bigint DEFAULT '0' COMMENT '交易代币总量',
  `token_txn_count` bigint DEFAULT '0' COMMENT 'token交易数量',
  `token_txn_count_from` bigint DEFAULT '0' COMMENT 'token发送交易数量',
  `token_txn_count_to` bigint DEFAULT '0' COMMENT 'token接收交易数量',
  `token_receivers` bigint DEFAULT NULL COMMENT 'token接受地址数',
  `token_senders` bigint DEFAULT NULL COMMENT 'token发送地址数',
  `token_transfer_amount` decimal(64,2) DEFAULT '0.00' COMMENT 'token转账金额(erc20地址)',
  `token_transfer_count` bigint DEFAULT NULL COMMENT 'token转账笔数(erc20地址)',
  `unique_receivers` bigint DEFAULT '0' COMMENT 'token接受者数量(erc20地址)',
  `unique_senders` bigint DEFAULT '0' COMMENT 'token发送者数量(erc20地址)',
  `total_unique` bigint DEFAULT '0' COMMENT 'token交易者数量(erc20地址)',
  `status` int DEFAULT '1' COMMENT '状态,1-正常',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `date_account_index` (`stats_date`,`account_address`),
  KEY `stats_date_index` (`stats_date`),
  KEY `account_address_index` (`account_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='账户统计表';

-- ----------------------------
-- Table structure for tb_approval
-- ----------------------------
DROP TABLE IF EXISTS `tb_approval`;
CREATE TABLE `tb_approval` (
  `id` bigint NOT NULL,
  `block_id` bigint DEFAULT NULL,
  `block_hash` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '区块hash',
  `tx_hash` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '交易hash',
  `tx_time` datetime DEFAULT NULL COMMENT '交易时间',
  `contract_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '合约地址',
  `token_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'token地址',
  `token_type` int DEFAULT NULL COMMENT 'token类型 1-erc20 2-erc721',
  `from` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'from地址',
  `to` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'to地址',
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '授权value值',
  `amount` varchar(100) COLLATE utf8mb4_bin DEFAULT NULL DEFAULT NULL COMMENT '授权金额',
  `token_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'tokenId',
  `tx_status` int DEFAULT NULL COMMENT '交易状态',
  `address_list` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '地址列表(from|to|contract)',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC COMMENT='approve交易信息表';

-- ----------------------------
-- Table structure for tb_base_coin_info
-- ----------------------------
DROP TABLE IF EXISTS `tb_base_coin_info`;
CREATE TABLE `tb_base_coin_info` (
  `id` bigint NOT NULL,
  `base_coin_name` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '基础币名称',
  `base_coin_symbol` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '基础币标识',
  `logo` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'logo',
  `decimals` bigint DEFAULT NULL COMMENT '精度',
  `total_supply` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '总发行量',
  `total_csupply` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '流通量',
  `genesis` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '初始量',
  `burn` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '销毁量',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='基础币信息表';

-- ----------------------------
-- Table structure for tb_base_coin_price
-- ----------------------------
DROP TABLE IF EXISTS `tb_base_coin_price`;
CREATE TABLE `tb_base_coin_price` (
  `id` bigint NOT NULL,
  `base_coin_name` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '基础币名称',
  `base_coin_symbol` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '基础币标识',
  `price_date` varchar(10) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '日期',
  `kline_id` bigint DEFAULT NULL COMMENT '行情id',
  `kline_open` decimal(64,18) DEFAULT NULL COMMENT '行情开盘价',
  `kline_close` decimal(64,18) DEFAULT NULL COMMENT '行情收盘价',
  `kline_high` decimal(64,18) DEFAULT NULL COMMENT '行情最高价',
  `kline_low` decimal(64,18) DEFAULT NULL COMMENT '行情最低价',
  `kline_amount` decimal(64,18) DEFAULT NULL COMMENT '行情基础币交易量',
  `kline_vol` decimal(64,18) DEFAULT NULL COMMENT '行情报价币交易量',
  `kline_count` bigint DEFAULT NULL COMMENT '行情交易次数',
  `status` int DEFAULT '1' COMMENT '状态 1-正常',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `price_date_index` (`price_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='基础币价格表';

-- ----------------------------
-- Table structure for tb_block
-- ----------------------------
DROP TABLE IF EXISTS `tb_block`;
CREATE TABLE `tb_block` (
  `id` bigint NOT NULL,
  `block_id` bigint DEFAULT NULL COMMENT '区块号',
  `block_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '区块hash',
  `parent_block_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '父区块hash',
  `validated_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '确认节点',
  `block_reward` decimal(64,18) DEFAULT NULL COMMENT '区块奖励',
  `difficulty` bigint DEFAULT NULL COMMENT '难度',
  `total_difficulty` bigint DEFAULT NULL COMMENT '总难度',
  `size` bigint DEFAULT NULL COMMENT '大小',
  `gas_used` bigint DEFAULT NULL COMMENT '使用gas',
  `gas_limit` bigint DEFAULT NULL COMMENT '限制gas',
  `extra_data` longtext COLLATE utf8mb4_bin COMMENT '附加数据',
  `sha3_uncles` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'sha3',
  `nonce` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'nonce号',
  `logs_bloom` longtext COLLATE utf8mb4_bin COMMENT 'LogsBloom',
  `mix_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'MixHash',
  `receipts_root` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'ReceiptsRoot',
  `stateRoot` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'StateRoot',
  `transactions_root` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'TransactionsRoot',
  `tx_num` bigint DEFAULT NULL COMMENT '交易数量',
  `internal_tx_num` bigint DEFAULT NULL COMMENT '内部交易数量',
  `block_time` datetime DEFAULT NULL COMMENT '出块时间',
  `uncles` longtext COLLATE utf8mb4_bin COMMENT 'Uncles',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `block_id` (`block_id`),
  KEY `block_hash` (`block_hash`),
  KEY `validated_hash_index` (`validated_hash`),
  KEY `block_time_index` (`block_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='区块信息表';

-- ----------------------------
-- Table structure for tb_block_control
-- ----------------------------
DROP TABLE IF EXISTS `tb_block_control`;
CREATE TABLE `tb_block_control` (
  `id` bigint NOT NULL,
  `chain_name` varchar(60) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '链名称',
  `control_type` int DEFAULT NULL COMMENT '控制类型 1-block 2-internalTxn 3-account 4-balance 5-chainReport',
  `write_block_id_lock` bigint DEFAULT NULL COMMENT '当前同步区块号',
  `last_analyze_block_id` bigint DEFAULT NULL COMMENT '已同步最后区块号',
  `sync_node_num` varchar(60) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '同步节点',
  `long_scan_time_period` bigint DEFAULT NULL COMMENT '扫描最长时间',
  `short_scan_time_period` bigint DEFAULT NULL COMMENT '扫描最短时间',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='区块控制表';

-- ----------------------------
-- Table structure for tb_config
-- ----------------------------
DROP TABLE IF EXISTS `tb_config`;
CREATE TABLE `tb_config` (
  `id` bigint NOT NULL,
  `types` int DEFAULT NULL COMMENT '配置类型,1-rpc相关新配置',
  `key` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '配置键值',
  `value` text COLLATE utf8mb4_bin COMMENT '配置值',
  `description` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '描述',
  `status` int DEFAULT '1' COMMENT '状态 1-有效',
  `is_deleted` int DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='配置表';

-- ----------------------------
-- Table structure for tb_contract
-- ----------------------------
DROP TABLE IF EXISTS `tb_contract`;
CREATE TABLE `tb_contract` (
  `id` bigint NOT NULL,
  `block_id` bigint DEFAULT NULL COMMENT '区块号',
  `block_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '区块hash',
  `tx_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '交易hash',
  `contract_creator` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '创建者',
  `contract_address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '合约地址',
  `contract_type` int DEFAULT NULL COMMENT '合约类型：1-erc20 2-erc721 3-其他合约',
  `name` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '合约名称',
  `symbol` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '合约标识',
  `logo` longtext COLLATE utf8mb4_bin,
  `website` longtext COLLATE utf8mb4_bin,
  `social_profiles` longtext COLLATE utf8mb4_bin,
  `decimals` bigint DEFAULT NULL COMMENT '合约精度',
  `total_supply` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '总量',
  `contract_info` longtext COLLATE utf8mb4_bin COMMENT '合约信息',
  `contract_code` longtext COLLATE utf8mb4_bin COMMENT '字节码',
  `abi` longtext COLLATE utf8mb4_bin COMMENT 'abi',
  `source_code` longtext COLLATE utf8mb4_bin COMMENT '源码',
  `license_type` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'license类型',
  `compiler_version` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '编译器版本',
  `compiler_type` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '编译类型:SingleFile/MultiFile',
  `optimization_enabled` tinyint DEFAULT '0' COMMENT '编译优化开启状态 0-未开启 1-开启',
  `optimization_runs` int DEFAULT '200' COMMENT '编译优化时间',
  `evm_version` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'EVM版本',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_verfied` tinyint DEFAULT '0' COMMENT '验证状态 0-未验证 1-验证通过 2-验证失败',
  `verfied_time` timestamp NULL DEFAULT NULL COMMENT '验证时间',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `is_implements` tinyint DEFAULT NULL,
  `is_165interface` tinyint DEFAULT NULL COMMENT 'ERC-165 Interface',
  `is_metadata` tinyint DEFAULT NULL COMMENT 'Metadata',
  `is_enumerable` tinyint DEFAULT NULL COMMENT 'Enumerable',
  `is_json_format_code` int DEFAULT '0' COMMENT 'json 0 1',
  `settings` text COLLATE utf8mb4_bin,
  `arguments` text COLLATE utf8mb4_bin,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_unique_index` (`contract_address`),
  KEY `block_id_index` (`block_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='合约信息表';

-- ----------------------------
-- Table structure for tb_contract_account
-- ----------------------------
DROP TABLE IF EXISTS `tb_contract_account`;
CREATE TABLE `tb_contract_account` (
  `id` bigint NOT NULL,
  `block_id` bigint DEFAULT NULL COMMENT '区块号',
  `block_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '区块hash',
  `tx_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '交易hash',
  `contract_address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '合约地址',
  `contract_type` int DEFAULT NULL COMMENT '合约类型：1-erc20 2-erc721',
  `account_address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '账户地址',
  `account_type` int DEFAULT NULL COMMENT '账户类型：1-account 2-contract',
  `balance` decimal(64,18) DEFAULT NULL COMMENT '余额',
  `token_id` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'tokenId',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `contract_unique_index` (`contract_address`,`account_address`,`token_id`),
  KEY `block_id_index` (`block_id`),
  KEY `contract_index` (`contract_address`),
  KEY `account_index` (`account_address`),
  KEY `tokenid_index` (`token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='合约账户表';

-- ----------------------------
-- Table structure for tb_contract_compiler_version
-- ----------------------------
DROP TABLE IF EXISTS `tb_contract_compiler_version`;
CREATE TABLE `tb_contract_compiler_version` (
  `id` bigint NOT NULL,
  `compiler_version` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '编译器版本号',
  `compiler_version_detail` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT ' 编译器版本详细信息',
  `sync_time` timestamp NULL DEFAULT NULL COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='合约编译版本表';

-- ----------------------------
-- Table structure for tb_contract_function
-- ----------------------------
DROP TABLE IF EXISTS `tb_contract_function`;
CREATE TABLE `tb_contract_function` (
  `id` bigint NOT NULL,
  `contract_address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '合约地址',
  `function_key` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '函数KEY',
  `function_name` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '函数名',
  `function_args` longtext COLLATE utf8mb4_bin COMMENT '函数参数',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='合约函数map表';

-- ----------------------------
-- Table structure for tb_contract_license
-- ----------------------------
DROP TABLE IF EXISTS `tb_contract_license`;
CREATE TABLE `tb_contract_license` (
  `id` bigint NOT NULL,
  `license_type` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '合约license版本',
  `symbol` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '版本简称',
  `sync_time` datetime DEFAULT NULL COMMENT '同步时间',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

-- ----------------------------
-- Table structure for tb_contract_transaction
-- ----------------------------
DROP TABLE IF EXISTS `tb_contract_transaction`;
CREATE TABLE `tb_contract_transaction` (
  `id` bigint NOT NULL,
  `block_id` bigint DEFAULT NULL COMMENT '区块号',
  `block_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '区块hash',
  `tx_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '交易hash',
  `tx_time` datetime DEFAULT NULL COMMENT '交易时间',
  `contract_address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '合约地址',
  `token_address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'token地址',
  `token_type` int DEFAULT NULL COMMENT '合约类型 1-erc20 2-erc721',
  `from` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '发起地址',
  `to` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '到大地址',
  `value` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '交易值',
  `amount` decimal(64,2) DEFAULT '0.00' COMMENT '交易金额',
  `token_id` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'tokenId',
  `tx_status` int DEFAULT NULL COMMENT '交易状态',
  `address_list` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '地址列表(from|to|contract)',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `block_id_index` (`block_id`),
  KEY `token_address_index` (`token_address`),
  KEY `tx_hash_index` (`tx_hash`),
  KEY `from_index` (`from`),
  KEY `to_index` (`to`),
  KEY `tx_time_index` (`tx_time`),
  KEY `address_list_index` (`address_list`),
  KEY `ct_contract_address_index` (`contract_address`),
  KEY `ct_token_type` (`token_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='合约交易信息表';

-- ----------------------------
-- Table structure for tb_event
-- ----------------------------
DROP TABLE IF EXISTS `tb_event`;
CREATE TABLE `tb_event` (
  `id` bigint NOT NULL,
  `event_type` int DEFAULT NULL COMMENT '时间类型 1：交易log',
  `block_id` bigint DEFAULT NULL COMMENT '区块号',
  `block_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'blockHash',
  `tx_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '交易hash',
  `tx_index` bigint DEFAULT NULL COMMENT '交易索引',
  `contract_address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '合约地址',
  `log_index` bigint DEFAULT NULL COMMENT 'log索引',
  `event_info` longtext COLLATE utf8mb4_bin COMMENT '事件信息',
  `method_id` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'methodId',
  `topics1` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'topics1',
  `topics2` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'topics2',
  `topics3` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'topics3',
  `topics4` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'topics4',
  `topics5` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'topics5',
  `topics6` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'topics6',
  `removed` varchar(20) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '删除状态 true false',
  `data` longtext COLLATE utf8mb4_bin COMMENT '数据',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `block_id_index` (`block_id`),
  KEY `tx_hash_index` (`tx_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='事件表';

-- ----------------------------
-- Table structure for tb_evm_version
-- ----------------------------
DROP TABLE IF EXISTS `tb_evm_version`;
CREATE TABLE `tb_evm_version` (
  `id` bigint NOT NULL,
  `evm_version` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'EVM虚拟机版本',
  `info` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '说明',
  `sync_time` timestamp NULL DEFAULT NULL COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

-- ----------------------------
-- Table structure for tb_forked_block
-- ----------------------------
DROP TABLE IF EXISTS `tb_forked_block`;
CREATE TABLE `tb_forked_block` (
  `id` bigint NOT NULL,
  `block_id` bigint DEFAULT NULL COMMENT '区块号',
  `block_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '区块hash',
  `parent_block_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '父区块hash',
  `reorg_depth` int DEFAULT NULL COMMENT '回滚深度',
  `validated_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '确认节点',
  `block_reward` decimal(64,18) DEFAULT NULL COMMENT '区块奖励',
  `difficulty` bigint DEFAULT NULL COMMENT '难度',
  `total_difficulty` bigint DEFAULT NULL COMMENT '总难度',
  `size` bigint DEFAULT NULL COMMENT '大小',
  `gas_used` bigint DEFAULT NULL COMMENT '使用gas',
  `gas_limit` bigint DEFAULT NULL COMMENT '限制gas',
  `extra_data` longtext COLLATE utf8mb4_bin COMMENT '附加数据',
  `sha3_uncles` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'sha3',
  `nonce` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'nonce号',
  `logs_bloom` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'logsBloom',
  `mix_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'MixHash',
  `receipts_root` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'ReceiptsRoot',
  `stateRoot` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'StateRoot',
  `transactions_root` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'TransactionsRoot',
  `tx_num` bigint DEFAULT NULL COMMENT '交易数量',
  `internal_tx_num` bigint DEFAULT NULL COMMENT '内部交易数量',
  `block_time` datetime DEFAULT NULL COMMENT '出块时间',
  `uncles` longtext COLLATE utf8mb4_bin COMMENT 'Uncles',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='分叉区块信息表';

-- ----------------------------
-- Table structure for tb_internal_transaction
-- ----------------------------
DROP TABLE IF EXISTS `tb_internal_transaction`;
CREATE TABLE `tb_internal_transaction` (
  `id` bigint NOT NULL,
  `parent_id` bigint DEFAULT NULL COMMENT '父级Id',
  `block_id` bigint DEFAULT NULL COMMENT '区块号',
  `block_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '区块hash',
  `tx_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '交易hash',
  `tx_time` datetime DEFAULT NULL COMMENT '交易时间',
  `contract_address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '合约地址',
  `types` varchar(60) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'CALL type',
  `from` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '发起地址',
  `to` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '到大地址',
  `value` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '交易值',
  `amount` decimal(64,18) DEFAULT NULL COMMENT '交易金额',
  `gas` bigint DEFAULT NULL COMMENT 'gas',
  `gas_used` bigint DEFAULT NULL COMMENT 'gasUsed',
  `input` longtext COLLATE utf8mb4_bin COMMENT '输入数据',
  `output` longtext COLLATE utf8mb4_bin COMMENT '输出数据',
  `time` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '执行时间',
  `tx_status` int DEFAULT NULL COMMENT '交易状态',
  `address_list` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '地址列表(from|to|contract)',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `block_index` (`block_id`),
  KEY `value_index` (`value`),
  KEY `tx_hash_index` (`tx_hash`),
  KEY `from_index` (`from`),
  KEY `to_index` (`to`),
  KEY `address_list_index` (`address_list`),
  KEY `contract_address_index` (`contract_address`),
  KEY `value_from_index` (`value`,`from`),
  KEY `value_to_index` (`value`,`to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='内部交易信息表';

-- ----------------------------
-- Table structure for tb_original_block
-- ----------------------------
DROP TABLE IF EXISTS `tb_original_block`;
CREATE TABLE `tb_original_block` (
  `id` bigint NOT NULL,
  `block_id` bigint DEFAULT NULL COMMENT '区块号',
  `block_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '区块hash',
  `block_data` longtext COLLATE utf8mb4_bin COMMENT '区块数据',
  `node` varchar(60) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '同步节点标识',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `block_id_index` (`block_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='原始区块信息表';

-- ----------------------------
-- Table structure for tb_original_transaction
-- ----------------------------
DROP TABLE IF EXISTS `tb_original_transaction`;
CREATE TABLE `tb_original_transaction` (
  `id` bigint NOT NULL,
  `block_id` bigint DEFAULT NULL COMMENT '区块号',
  `block_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '区块hash',
  `tx_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '交易hash',
  `tx_data` longtext COLLATE utf8mb4_bin COMMENT '交易数据',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `block_Id_index` (`block_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='原始交易信息表';

-- ----------------------------
-- Table structure for tb_pending_block
-- ----------------------------
DROP TABLE IF EXISTS `tb_pending_block`;
CREATE TABLE `tb_pending_block` (
  `id` bigint NOT NULL,
  `block_id` bigint DEFAULT NULL COMMENT '区块号',
  `block_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '区块hash',
  `block_data` longtext COLLATE utf8mb4_bin COMMENT '区块数据',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='pengding区块信息表';

-- ----------------------------
-- Table structure for tb_public_address_tag
-- ----------------------------
DROP TABLE IF EXISTS `tb_public_address_tag`;
CREATE TABLE `tb_public_address_tag` (
  `id` bigint NOT NULL,
  `address` varchar(42) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `tag` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `website` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `status` int DEFAULT '1' COMMENT ',1- 2-',
  `is_deleted` tinyint DEFAULT '0' COMMENT ' 0- 1-',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_idx` (`address`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='tag';

-- ----------------------------
-- Table structure for tb_token_price
-- ----------------------------
DROP TABLE IF EXISTS `tb_token_price`;
CREATE TABLE `tb_token_price` (
  `id` bigint NOT NULL,
  `token_address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '代币地址',
  `token_name` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '代币名称',
  `token_symbol` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '代币标识',
  `token_logo` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '代币logo',
  `token_introduction` longtext COLLATE utf8mb4_bin COMMENT '代币简介',
  `total_supply` decimal(64,18) unsigned DEFAULT '0.000000000000000000' COMMENT '流通总量',
  `kline_symbol` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '行情交易对',
  `kline_id` bigint DEFAULT NULL COMMENT '行情id',
  `kline_open` decimal(64,18) DEFAULT NULL COMMENT '行情开盘价',
  `kline_close` decimal(64,18) DEFAULT NULL COMMENT '行情收盘价',
  `kline_high` decimal(64,18) DEFAULT NULL COMMENT '行情最高价',
  `kline_low` decimal(64,18) DEFAULT NULL COMMENT '行情最低价',
  `kline_amount` decimal(64,18) DEFAULT NULL COMMENT '行情基础币交易量',
  `kline_vol` decimal(64,18) DEFAULT NULL COMMENT '行情报价币交易量',
  `kline_count` bigint DEFAULT NULL COMMENT '行情交易次数',
  `status` int DEFAULT '1' COMMENT '状态 1-正常',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='token价格表';

-- ----------------------------
-- Table structure for tb_transaction
-- ----------------------------
DROP TABLE IF EXISTS `tb_transaction`;
CREATE TABLE `tb_transaction` (
  `id` bigint NOT NULL,
  `block_id` bigint DEFAULT NULL COMMENT '区块号',
  `block_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '区块hash',
  `tx_hash` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '交易hash',
  `tx_type` int DEFAULT NULL COMMENT '交易类型 1：普通交易 2-合约交易',
  `tx_time` datetime DEFAULT NULL COMMENT '交易时间',
  `tx_index` bigint DEFAULT NULL COMMENT '交易索引',
  `contract_address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '合约地址',
  `from` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '发起地址',
  `to` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '到达地址',
  `value` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '交易值',
  `amount` decimal(64,18) DEFAULT NULL COMMENT '交易金额',
  `tx_fee` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '交易费',
  `tx_status` int DEFAULT NULL COMMENT '交易状态',
  `error_info` longtext COLLATE utf8mb4_bin COMMENT '错误信息',
  `cumulative_gas_used` bigint DEFAULT NULL COMMENT 'CumulativeGasUsed',
  `gas_used` bigint DEFAULT NULL COMMENT '使用gas',
  `gas_limit` bigint DEFAULT NULL COMMENT '限制gas',
  `gas_price` bigint DEFAULT NULL COMMENT 'gas价格',
  `nonce` bigint DEFAULT NULL COMMENT 'nonce号',
  `input_data` longtext COLLATE utf8mb4_bin COMMENT '输入数据',
  `v` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'V',
  `r` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'R',
  `s` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'S',
  `bloom` longtext COLLATE utf8mb4_bin COMMENT 'bloom',
  `trace_data` longtext COLLATE utf8mb4_bin COMMENT '痕迹数据',
  `except_data` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '异常记录',
  `address_list` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '地址列表(from|to|contract)',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `block_id_index` (`block_id`),
  KEY `tx_hash_index` (`tx_hash`),
  KEY `tx_time_index` (`tx_time`),
  KEY `from_index` (`from`),
  KEY `to_index` (`to`),
  KEY `address_list_Index` (`address_list`),
  KEY `tx_status_index` (`tx_status`),
  KEY `contract_address_index` (`contract_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='交易信息表';

-- ----------------------------
-- Table structure for tb_validator
-- ----------------------------
DROP TABLE IF EXISTS `tb_validator`;
CREATE TABLE `tb_validator` (
  `id` bigint NOT NULL,
  `address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '地址',
  `fee_address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'fee地址',
  `first_block_id` bigint DEFAULT NULL COMMENT '第一个验证块',
  `last_block_id` bigint DEFAULT NULL COMMENT '最后一个验证块',
  `active_status` int DEFAULT NULL COMMENT '存活状态 1-存活 2-挂起',
  `working_lives` bigint DEFAULT NULL COMMENT '工作总是时长 秒',
  `start_time` datetime DEFAULT NULL COMMENT '开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '截止时间',
  `jailed_num` int DEFAULT NULL COMMENT '惩罚次数',
  `total_incoming` decimal(64,18) DEFAULT NULL COMMENT '总收益',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_unique_index` (`address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='验证者信息表';

-- ----------------------------
-- Table structure for tb_validator_snapshot
-- ----------------------------
DROP TABLE IF EXISTS `tb_validator_snapshot`;
CREATE TABLE `tb_validator_snapshot` (
  `id` bigint NOT NULL,
  `block_id` bigint DEFAULT NULL COMMENT '区块号',
  `block_time` datetime DEFAULT NULL COMMENT '出块时间',
  `validator_address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '验证者地址',
  `validator_status` bigint DEFAULT NULL COMMENT '验证者状态',
  `fee_address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'fee地址',
  `stake_coins` decimal(64,18) DEFAULT NULL COMMENT '质押币量',
  `incoming` decimal(64,18) DEFAULT NULL COMMENT '总收益',
  `jailed` decimal(64,18) DEFAULT '0.000000000000000000' COMMENT '惩罚数',
  `last_withdraw_block` bigint DEFAULT NULL COMMENT '最后提现区块号',
  `memory_stakes` longtext COLLATE utf8mb4_bin COMMENT 'memoryStakes',
  `voting_power` decimal(64,18) DEFAULT NULL COMMENT '投票量',
  `status` int DEFAULT '1' COMMENT '状态,1-正常 2-冻结',
  `is_deleted` tinyint DEFAULT '0' COMMENT '删除状态 0-正常 1-删除',
  `sync_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '同步时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `block_id_index` (`block_id`),
  KEY `validator_address_index` (`validator_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='验证者快照信息表';

-- ----------------------------
-- Table structure for tb_verify_code
-- ----------------------------
DROP TABLE IF EXISTS `tb_verify_code`;
CREATE TABLE `tb_verify_code` (
  `id` bigint NOT NULL,
  `verify_type` tinyint DEFAULT NULL COMMENT '验证码类型 1-手机 2-邮箱',
  `area_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '国际区号',
  `verify_account` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '验证账号',
  `use_type` tinyint DEFAULT NULL COMMENT '使用类型 1-用户注册, 2-忘记密码,3:微信绑定',
  `verify_code` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '验证码',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='验证码表';

-- ----------------------------
-- Table structure for tb_whitelist
-- ----------------------------
DROP TABLE IF EXISTS `tb_whitelist`;
CREATE TABLE `tb_whitelist` (
  `id` bigint NOT NULL,
  `contract_address` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'erc20合约地址',
  `name` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '合约名称',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin COMMENT='erc20白名单表';

SET FOREIGN_KEY_CHECKS = 1;




-- ----------------------------
-- Initialized data
-- ----------------------------

-- add base coin info with supply
-- INSERT INTO `tb_base_coin_info` VALUES (1, 'MARS', 'MARS', '', 18, '1000000000000000000000000000', '0', '0', '0', 1, 0, '2021-06-01 17:07:52', '2021-06-01 17:07:52', '2021-06-01 17:07:52');

-- add block control
INSERT INTO `tb_block_control` VALUES (6799211979904000001, 'heco', 1, 1, 0, 'blockScan1', 164704296, 5481, 1, 0, '2021-06-01 17:07:52', '2021-05-24 10:13:06', '2021-06-01 17:07:52');
INSERT INTO `tb_block_control` VALUES (6799211979904000002, 'heco', 2, 1, 0, '', 132840389, 3693, 1, 0, '2021-06-01 17:07:51', '2021-05-24 10:13:06', '2021-06-01 17:07:51');
INSERT INTO `tb_block_control` VALUES (6799211979904000003, 'heco', 3, 1, 0, '', 132840389, 236, 1, 0, '2021-06-01 17:07:51', '2021-05-26 17:16:14', '2021-06-01 17:07:51');
INSERT INTO `tb_block_control` VALUES (6799211979904000004, 'heco', 4, 1, 0, '', 132840389, 236, 1, 0, '2021-06-01 17:07:52', '2021-05-26 17:16:14', '2021-06-01 17:07:52');
INSERT INTO `tb_block_control` VALUES (6799211979904000005, 'heco', 5, 1, 0, '', 132840389, 236, 1, 0, '2021-06-01 17:07:52', '2021-05-26 17:16:14', '2021-06-01 17:07:52');

-- ----------------------------
-- Records of tb_config
-- ----------------------------
INSERT INTO `tb_config` (`id`, `types`, `key`, `value`, `description`) VALUES
(101, 2, "user_api_key_limit", 5, 'API请求频率限制'),
(102, 2, "user_max_watch_count", 50, '用户监控地址交易最大数量'),
(103, 2, "user_max_txn_note_count", 2000, '用户创建交易备注最大数量'),
(104, 2, "user_max_address_note_count", 1000, "用户创建地址备注最大数量"),
(105, 2, "user_max_token_ignore_count", 30, "用户最大忽略token数量"),
(106, 2, "user_max_verified_address_count", 1000, "用户最大验证地址数量"),
(107, 2, "user_max_watch_email_send_day_count", 200, "用户每天最大发送邮件数量"),
(108, 2, "user_max_custom_abi_count", 10, "用户最大自定义abi数量");

-- ----------------------------
-- Records of tb_evm_version
-- ----------------------------
INSERT INTO `tb_evm_version` VALUES (10001,'default','compiler defaults',NULL,NULL,NULL),(10002,'byzantium','default for <=v0.5.4',NULL,NULL,NULL);


-- ----------------------------
-- Records of tb_contract_license
-- ----------------------------
INSERT INTO `tb_contract_license` VALUES (10001,'NO License','None',NULL,NULL,NULL),(10002,'The Unilicense','Unlicense',NULL,NULL,NULL),(10003,'MIT License','MIT',NULL,NULL,NULL),(10004,'GNU General Public License v2.0','GNU GPLv2',NULL,NULL,NULL),(10005,'GNU General Public License v3.0','GNU GPLv3',NULL,NULL,NULL),(10006,'GNU Lesser General Public License v2.1','GNU LGPLv2.1',NULL,NULL,NULL),(10007,'GNU Lesser General Public License v3.0','GNU LGPLv3',NULL,NULL,NULL),(10008,'BSD 2-clause \"Simplified\" license','BSD-2-Clause',NULL,NULL,NULL),(10009,'BSD 3-clause \"New\" Or \"Revised\" license','BSD-3-Clause',NULL,NULL,NULL),(10010,'Mozilla Public License 2.0','MPL-2.0',NULL,NULL,NULL),(10011,'Open Software License 3.0','OSL-3.0',NULL,NULL,NULL),(10012,'Apache 2.0','Apache-2.0',NULL,NULL,NULL),(10013,'GNU Affero General Public License','GNU AGPLv3',NULL,NULL,NULL),(10014,'Business Source License','BSL 1.1',NULL,NULL,NULL);


-- ----------------------------
-- Records of tb_contract_compiler_version
-- ----------------------------
INSERT INTO `tb_contract_compiler_version` VALUES (9986,'0.8.19','v0.8.19+commit.7dd6d404','2023-05-04 10:20:00','2023-05-04 03:35:39','2023-05-04 03:35:39'),(9987,'0.8.18','v0.8.18+commit.87f61d96','2023-05-04 10:30:00','2023-05-04 03:35:42','2023-05-04 03:35:42'),(9988,'0.8.17','v0.8.17+commit.8df45f5f','2021-05-22 15:35:36','2021-05-22 15:35:40','2021-05-22 15:35:42'),(9989,'0.8.16','v0.8.16+commit.07a7930e','2021-05-22 15:35:36','2021-05-22 15:35:40','2021-05-22 15:35:42'),(9990,'0.8.15','v0.8.15+commit.e14f2714','2021-05-22 15:35:36','2021-05-22 15:35:40','2021-05-22 15:35:42'),(9991,'0.8.14','v0.8.14+commit.80d49f37','2021-05-22 15:35:36','2021-05-22 15:35:40','2021-05-22 15:35:42'),(9992,'0.8.13','v0.8.13+commit.abaa5c0e','2021-05-22 15:35:36','2021-05-22 15:35:40','2021-05-22 15:35:42'),(9993,'0.8.12','v0.8.12+commit.f00d7308','2021-05-22 15:35:36','2021-05-22 15:35:40','2021-05-22 15:35:42'),(9994,'0.8.11','v0.8.11+commit.d7f03943','2021-05-22 15:35:36','2021-05-22 15:35:40','2021-05-22 15:35:42'),(9995,'0.8.10','v0.8.10+commit.fc410830','2021-05-22 15:35:36','2021-05-22 15:35:40','2021-05-22 15:35:42'),(9996,'0.8.9','v0.8.9+commit.e5eed63a','2021-05-22 15:35:36','2021-05-22 15:35:40','2021-05-22 15:35:42'),(9997,'0.8.8','v0.8.8+commit.dddeac2f','2021-05-22 15:35:36','2021-05-22 15:35:40','2021-05-22 15:35:42'),(9998,'0.8.7','v0.8.7+commit.e28d00a7','2021-05-22 15:35:36','2021-05-22 15:35:40','2021-05-22 15:35:42'),(9999,'0.8.6','v0.8.6+commit.11564f7e','2021-05-22 15:35:36','2021-05-22 15:35:40','2021-05-22 15:35:42'),(10000,'0.8.5','v0.8.5+commit.a4f2e591','2021-05-22 15:35:36','2021-05-22 15:35:40','2021-05-22 15:35:42'),(10001,'0.8.4','v0.8.4+commit.c7e474f2','2021-05-22 15:35:36','2021-05-22 15:35:40','2021-05-22 15:35:42'),(10002,'0.8.3','v0.8.3+commit.8d00100c','2021-05-22 15:36:41','2021-05-22 15:36:43','2021-05-22 15:36:46'),(10003,'0.8.2','v0.8.2+commit.661d1103','2021-05-22 15:37:27','2021-05-22 15:37:30','2021-05-22 15:37:31'),(10004,'0.8.1','v0.8.1+commit.df193b15','2021-05-22 15:38:26','2021-05-22 15:38:28','2021-05-22 15:38:31'),(10005,'0.8.0','v0.8.0+commit.c7dfd78e','2021-05-22 15:39:07','2021-05-22 15:39:10','2021-05-22 15:39:12'),(10006,'0.7.6','v0.7.6+commit.7338295f','2021-05-22 15:39:43','2021-05-22 15:39:45','2021-05-22 15:39:47'),(10007,'0.7.5','v0.7.5+commit.eb77ed08',NULL,NULL,NULL),(10008,'0.7.4','v0.7.4+commit.3f05b770',NULL,NULL,NULL),(10009,'0.7.3','v0.7.3+commit.9bfce1f6',NULL,NULL,NULL),(10010,'0.7.2','v0.7.2+commit.51b20bc0',NULL,NULL,NULL),(10011,'0.7.1','v0.7.1+commit.f4a555be',NULL,NULL,NULL),(10012,'0.7.0','v0.7.0+commit.9e61f92b',NULL,NULL,NULL),(10013,'0.6.12','v0.6.12+commit.27d51765',NULL,NULL,NULL),(10014,'0.6.11','v0.6.11+commit.5ef660b1',NULL,NULL,NULL),(10015,'0.6.10','v0.6.10+commit.00c0fcaf',NULL,NULL,NULL),(10016,'0.6.9','v0.6.9+commit.3e3065ac',NULL,NULL,NULL),(10017,'0.6.8','v0.6.8+commit.0bbfe453',NULL,NULL,NULL),(10018,'0.6.7','v0.6.7+commit.b8d736ae',NULL,NULL,NULL),(10019,'0.6.6','v0.6.6+commit.6c089d02',NULL,NULL,NULL),(10020,'0.6.5','v0.6.5+commit.f956cc89',NULL,NULL,NULL),(10021,'0.6.4','v0.6.4+commit.1dca32f3',NULL,NULL,NULL),(10022,'0.6.3','v0.6.3+commit.8dda9521',NULL,NULL,NULL),(10023,'0.6.2','v0.6.2+commit.bacdbe57',NULL,NULL,NULL),(10024,'0.6.1','v0.6.1+commit.e6f7d5a4',NULL,NULL,NULL),(10025,'0.6.0','v0.6.0+commit.26b70077',NULL,NULL,NULL),(10026,'0.5.17','v0.5.17+commit.d19bba13',NULL,NULL,NULL),(10027,'0.5.16','v0.5.16+commit.9c3226ce',NULL,NULL,NULL),(10028,'0.5.15','v0.5.15+commit.6a57276f',NULL,NULL,NULL),(10029,'0.5.14','v0.5.14+commit.01f1aaa4',NULL,NULL,NULL),(10030,'0.5.13','v0.5.13+commit.5b0b510c',NULL,NULL,NULL),(10031,'0.5.12','v0.5.12+commit.7709ece9',NULL,NULL,NULL),(10032,'0.5.11','v0.5.11+commit.22be8592',NULL,NULL,NULL),(10033,'0.5.11','v0.5.11+commit.c082d0b4',NULL,NULL,NULL),(10034,'0.5.10','v0.5.10+commit.5a6ea5b1',NULL,NULL,NULL),(10035,'0.5.9','v0.5.9+commit.c68bc34e',NULL,NULL,NULL),(10036,'0.5.9','v0.5.9+commit.e560f70d',NULL,NULL,NULL),(10037,'0.5.8','v0.5.8+commit.23d335f2',NULL,NULL,NULL),(10038,'0.5.7','v0.5.7+commit.6da8b019',NULL,NULL,NULL),(10039,'0.5.6','v0.5.6+commit.b259423e',NULL,NULL,NULL),(10040,'0.5.5','v0.5.5+commit.47a71e8f',NULL,NULL,NULL),(10041,'0.5.4','v0.5.4+commit.9549d8ff',NULL,NULL,NULL),(10042,'0.5.3','v0.5.3+commit.10d17f24',NULL,NULL,NULL),(10043,'0.5.2','v0.5.2+commit.1df8f40c',NULL,NULL,NULL),(10044,'0.5.1','v0.5.1+commit.c8a2cb62',NULL,NULL,NULL),(10045,'0.5.0','v0.5.0+commit.1d4f565a',NULL,NULL,NULL),(10046,'0.4.26','v0.4.26+commit.4563c3fc',NULL,NULL,NULL),(10047,'0.4.25','v0.4.25+commit.59dbf8f1',NULL,NULL,NULL),(10048,'0.4.24','v0.4.24+commit.e67f0147',NULL,NULL,NULL),(10049,'0.4.23','v0.4.23+commit.124ca40d',NULL,NULL,NULL),(10050,'0.4.22','v0.4.22+commit.4cb486ee',NULL,NULL,NULL);


