# 快速上手指南

## 🚀 5分钟快速开始

### 第一步：安装 Foundry（如果未安装）

```bash
# 安装 Foundry
curl -L https://foundry.paradigm.xyz | bash

# 重启终端后运行
foundryup

# 验证安装
forge --version
```

### 第二步：安装项目依赖

```bash
cd /Users/luxq/work/wuban/foundrytest
forge install foundry-rs/forge-std --no-commit
```

### 第三步：运行测试

```bash
# 方法1：使用一键测试脚本（推荐）
./test-all.sh

# 方法2：手动运行
forge test -vv
```

### 第四步：本地部署测试（可选）

```bash
# 终端1：启动本地测试网络
anvil

# 终端2：部署合约
./deploy-local.sh
```

## 📝 测试命令速查

```bash
# 编译合约
forge build

# 运行所有测试
forge test

# 运行测试并显示详细信息
forge test -vv

# 运行特定测试
forge test --match-test testTransfer -vv

# 生成覆盖率报告
forge coverage

# 生成 Gas 报告
forge test --gas-report

# 清理缓存
forge clean
```

## 🎯 项目亮点

1. **完整的 ERC20 实现** - 包含所有标准功能
2. **批量转账合约** - 支持批量和代理转账
3. **全面的测试覆盖** - 20+ 测试用例
4. **自动化脚本** - 一键测试和部署
5. **详细的中文文档** - 新手友好

## 🆘 常见问题

### Q: forge 命令找不到？
A: 需要先安装 Foundry，参考第一步。

### Q: 测试失败怎么办？
A: 运行 `forge test -vvvv` 查看详细错误信息。

### Q: 如何部署到测试网？
A: 修改 `.env` 中的私钥和 RPC URL，然后运行部署脚本。

### Q: 本地 RPC 连接失败？
A: 确保 Anvil 正在运行（执行 `anvil` 命令）。

## 📞 获取帮助

- 查看 README.md 获取完整文档
- 查看 [Foundry 官方文档](https://book.getfoundry.sh/)
- 查看合约源码中的注释

