// SPDX-License-Identifier: MIT
pragma solidity ^0.8.20;

import "forge-std/Script.sol";
import "../src/InternalTransfer.sol";

contract DeployInternalTransfer is Script {
    function run() external {
        uint256 deployerPrivateKey = vm.envUint("PRIVATE_KEY");

        vm.startBroadcast(deployerPrivateKey);

        // 部署内部转账合约
        InternalTransfer transferContract = new InternalTransfer();

        console.log("InternalTransfer deployed at:", address(transferContract));
        console.log("Owner:", transferContract.owner());

        vm.stopBroadcast();
    }
}

