#!/bin/bash

# 颜色定义
GREEN='\033[0;32m'
BLUE='\033[0;34m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

echo -e "${BLUE}================================${NC}"
echo -e "${BLUE}   RPC部署脚本${NC}"
echo -e "${BLUE}================================${NC}"
echo ""

# 检查.env文件是否存在
if [ ! -f .env ]; then
    echo -e "${RED}.env 文件不存在！${NC}"
    echo -e "${YELLOW}请创建.env文件并添加以下内容：${NC}"
    echo "PRIVATE_KEY=your_private_key_here"
    echo "RPC_URL=http://127.0.0.1:8545"
    exit 1
fi

# 加载环境变量
source .env

# 设置默认RPC URL
if [ -z "$RPC_URL" ]; then
    RPC_URL="http://127.0.0.1:8545"
fi

echo -e "${GREEN}使用 RPC: $RPC_URL${NC}"
echo ""

# 检查RPC是否可用
echo -e "${GREEN}[1/4] 检查RPC连接...${NC}"
curl -s -X POST -H "Content-Type: application/json" \
    --data '{"jsonrpc":"2.0","method":"eth_blockNumber","params":[],"id":1}' \
    $RPC_URL > /dev/null

if [ $? -ne 0 ]; then
    echo -e "${RED}无法连接到RPC ($RPC_URL)${NC}"
    if [ "$RPC_URL" == "http://127.0.0.1:8545" ]; then
        echo -e "${YELLOW}请先运行: anvil${NC}"
    else
        echo -e "${YELLOW}请检查RPC URL是否正确${NC}"
    fi
    exit 1
fi
echo -e "${GREEN}✓ RPC连接成功${NC}"
echo ""

# 编译合约
echo -e "${GREEN}[2/4] 编译合约...${NC}"
forge build
if [ $? -ne 0 ]; then
    echo -e "${RED}编译失败！${NC}"
    exit 1
fi
echo -e "${GREEN}✓ 编译成功${NC}"
echo ""

# 部署所有合约（使用 legacy 交易，禁用 EIP-1559）
echo -e "${GREEN}[3/4] 部署合约到 $RPC_URL...${NC}"
forge script script/DeployAll.s.sol:DeployAll \
    --rpc-url $RPC_URL \
    --broadcast \
    --legacy \
    -vvvv

if [ $? -ne 0 ]; then
    echo -e "${RED}部署失败！${NC}"
    exit 1
fi
echo -e "${GREEN}✓ 部署成功${NC}"
echo ""

# 显示部署信息
echo -e "${GREEN}[4/4] 部署信息${NC}"
echo -e "${YELLOW}查看 broadcast/ 目录获取详细的部署地址${NC}"
echo ""

echo -e "${BLUE}================================${NC}"
echo -e "${GREEN}部署完成！${NC}"
echo -e "${BLUE}================================${NC}"
