// SPDX-License-Identifier: MIT
pragma solidity ^0.8.20;

import "forge-std/Script.sol";
import "../src/ERC20Token.sol";

contract DeployERC20 is Script {
    function run() external {
        uint256 deployerPrivateKey = vm.envUint("PRIVATE_KEY");

        vm.startBroadcast(deployerPrivateKey);

        // 部署ERC20代币，初始供应量1000000
        ERC20Token token = new ERC20Token("Test Token", "TST", 18, 1000000);

        console.log("ERC20Token deployed at:", address(token));
        console.log("Total Supply:", token.totalSupply());
        console.log("Deployer Balance:", token.balanceOf(msg.sender));

        vm.stopBroadcast();
    }
}

