        console.log("");

        // 3. 进行一些初始化操作
        address testUser = 0x70997970C51812dc3A010C7d01b50e0d17dc79C8; // 测试账户
        uint256 transferAmount = 10000 * 10**18;

        // 给测试账户转一些代币
        token.transfer(testUser, transferAmount);
        console.log("=== Initial Setup ===");
        console.log("Transferred", transferAmount, "tokens to", testUser);
        console.log("Test user balance:", token.balanceOf(testUser));

        vm.stopBroadcast();
    }
}
// SPDX-License-Identifier: MIT
pragma solidity ^0.8.20;

import "forge-std/Script.sol";
import "../src/ERC20Token.sol";
import "../src/InternalTransfer.sol";

contract DeployAll is Script {
    function run() external {
        uint256 deployerPrivateKey = vm.envUint("PRIVATE_KEY");

        vm.startBroadcast(deployerPrivateKey);

        // 1. 部署ERC20代币
        ERC20Token token = new ERC20Token("Test Token", "TST", 18, 1000000);
        console.log("=== ERC20Token Deployed ===");
        console.log("Address:", address(token));
        console.log("Name:", token.name());
        console.log("Symbol:", token.symbol());
        console.log("Total Supply:", token.totalSupply());
        console.log("");

        // 2. 部署内部转账合约
        InternalTransfer transferContract = new InternalTransfer();
        console.log("=== InternalTransfer Deployed ===");
        console.log("Address:", address(transferContract));
        console.log("Owner:", transferContract.owner());

