#!/bin/bash

# 颜色定义
GREEN='\033[0;32m'
BLUE='\033[0;34m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

echo -e "${BLUE}================================${NC}"
echo -e "${BLUE}   Foundry 测试脚本${NC}"
echo -e "${BLUE}================================${NC}"
echo ""

# 加载环境变量（如果存在）
if [ -f .env ]; then
    source .env
    if [ ! -z "$RPC_URL" ] && [ "$RPC_URL" != "http://127.0.0.1:8545" ]; then
        echo -e "${YELLOW}使用自定义 RPC: $RPC_URL${NC}"
        echo ""
    fi
fi

# 1. 编译合约
echo -e "${GREEN}[1/5] 编译智能合约...${NC}"
forge build
if [ $? -ne 0 ]; then
    echo -e "${RED}编译失败！${NC}"
    exit 1
fi
echo -e "${GREEN}✓ 编译成功${NC}"
echo ""

# 2. 运行测试
echo -e "${GREEN}[2/5] 运行测试用例...${NC}"
if [ ! -z "$RPC_URL" ] && [ "$RPC_URL" != "http://127.0.0.1:8545" ]; then
    forge test --fork-url $RPC_URL -vv
else
    forge test -vv
fi
if [ $? -ne 0 ]; then
    echo -e "${RED}测试失败！${NC}"
    exit 1
fi
echo -e "${GREEN}✓ 测试通过${NC}"
echo ""

# 3. 生成测试覆盖率报告
echo -e "${GREEN}[3/5] 生成测试覆盖率报告...${NC}"
if [ ! -z "$RPC_URL" ] && [ "$RPC_URL" != "http://127.0.0.1:8545" ]; then
    forge coverage --fork-url $RPC_URL
else
    forge coverage
fi
echo -e "${GREEN}✓ 覆盖率报告生成完成${NC}"
echo ""

# 4. 运行Gas报告
echo -e "${GREEN}[4/5] 生成Gas消耗报告...${NC}"
if [ ! -z "$RPC_URL" ] && [ "$RPC_URL" != "http://127.0.0.1:8545" ]; then
    forge test --fork-url $RPC_URL --gas-report
else
    forge test --gas-report
fi
echo -e "${GREEN}✓ Gas报告生成完成${NC}"
echo ""

# 5. 运行详细测试（显示console.log输出）
echo -e "${GREEN}[5/5] 运行详细测试...${NC}"
if [ ! -z "$RPC_URL" ] && [ "$RPC_URL" != "http://127.0.0.1:8545" ]; then
    forge test --fork-url $RPC_URL -vvv
else
    forge test -vvv
fi
echo -e "${GREEN}✓ 详细测试完成${NC}"
echo ""

echo -e "${BLUE}================================${NC}"
echo -e "${GREEN}所有测试完成！${NC}"
echo -e "${BLUE}================================${NC}"
