// We require the Hardhat Runtime Environment explicitly here. This is optional
// but useful for running the script in a standalone fashion through `node <script>`.
//
// You can also run a script with `npx hardhat run <script>`. If you do that, Hardhat
// will compile your contracts, add the Hardhat Runtime Environment's members to the
// global scope, and execute the script.
const hre = require("hardhat");

async function main() {
  const Storage = await hre.ethers.getContractFactory("AddressStorage");
  const storage = await Storage.deploy();
  await storage.waitForDeployment();
  console.log(`Storage deployed to ${storage.target}`);

  const Witness = await hre.ethers.getContractFactory("Witness");
  const witness = await Witness.deploy();
  await witness.waitForDeployment();
  console.log(`Witness deployed to ${witness.target}`);

  // const Distribution = await hre.ethers.getContractFactory("Distribution");
  // const distribution = await Distribution.deploy();
  // await distribution.waitForDeployment();
  // console.log(`Distribution deployed to ${distribution.target}`);
}

// We recommend this pattern to be able to use async/await everywhere
// and properly handle errors.
main().catch((error) => {
  console.error(error);
  process.exitCode = 1;
});
