// SPDX-License-Identifier: GPL-3.0
pragma solidity ^0.8.20;

interface IAddressStorage {
    function setNmAddress(address addr, bool ok) external;

    function setContainerAddress(address addr, bool ok) external;

    function getNmAddresses() external view returns (address[] memory);

    function getContainerAddresses() external view returns (address[] memory);

    function isNmAddress(address addr) external view returns (bool);

    function isContainerAddress(address addr) external view returns (bool);
}