import { createClient } from "jsr:@supabase/supabase-js@2";
import { Bot } from 'https://deno.land/x/grammy@v1.34.0/mod.ts'

// 初始化 Supabase 客户端
const supabaseUrl = Deno.env.get("SUPABASE_URL") ?? "";
const supabaseKey = Deno.env.get("SUPABASE_SERVICE_ROLE_KEY") ?? "";
const supabase = createClient(supabaseUrl, supabaseKey);

async function processWebhook(req: any) {
  const body = await req.json();
  console.log('webhook body:', body);
  const { tg_chat_id, bot_id, content } = body;
  if (!tg_chat_id || !bot_id || !content) {
    console.error('Invalid request body:', body);
    return;
  }
  // 通过bot_id查询bot 获得tg_id
  const { data: botsData, error } = await supabase.from("bot").select("tg_token").eq("id", bot_id).single();
  if (error || !botsData) {
    console.error("获取Bot数据失败:", error?.message || "未知错误");
    return;
  }
  const bot = new Bot(botsData.tg_token);
  console.log('bot:', bot);
  await bot.api.sendMessage(tg_chat_id, content);
  console.log('Message sent successfully');
}

// 主流程：定时调用事件处理函数
Deno.serve(async (req) => {
  try {
    EdgeRuntime.waitUntil(processWebhook(req))
    return new Response(JSON.stringify({ message: "Events processed successfully" }), {
      status: 200,
      headers: { "Content-Type": "application/json" },
    });
  } catch (err) {
    console.error('Unexpected error:', err);
    return new Response(JSON.stringify({ error: 'Internal server error' }), {
      headers: { 'Content-Type': 'application/json' },
      status: 500,
    });
  }
});