import { Bot, Context, SessionFlavor } from 'https://deno.land/x/grammy@v1.34.0/mod.ts'
import { type ConversationFlavor, conversations, createConversation } from "https://raw.githubusercontent.com/grammyjs/conversations/c90b7fed54d610b7a37c2e0b90e728bc4d739d9b/src/mod.ts";
import { guard, isAdmin, reply } from "https://deno.land/x/grammy_guard/mod.ts";
import { freeStorage } from "https://deno.land/x/grammy_storages@v2.4.2/free/src/mod.ts";
import {
  createagent, updateagent, deleteagent,
  createrole, updaterole, listroles, deleterole,
  listagents, bindchatagent, answerQuestion,
  createknowleage, listknowledges, addknowlegecollection,
  listknowlegecollection, deleteknowlegecollection,
  createaction
} from "./conversations.ts";

// Define a guard
const isAdminGuard = guard(isAdmin, reply("You are not an admin"));
// Define a context flavor
interface SessionData { agent: { agentName: string; agentDescription: string; } }
type MyContext = Context & SessionFlavor<SessionData> & ConversationFlavor<Context>;

async function constructorBot(botToken: string) {
  const bot = new Bot<MyContext>(botToken)

  let storageAdapter = freeStorage<SessionData>(botToken);

  const storage = {
    storage: {
      type: "key",
      adapter: storageAdapter,
      getStorageKey: (ctx) => ctx.from?.id.toString(),
      prefix: "agent-",
    },
  }

  bot.use(conversations(storage));

  bot.use(createConversation(bindchatagent));
  bot.use(createConversation(createaction));
  bot.use(createConversation(createagent));
  bot.use(createConversation(updateagent));
  bot.use(createConversation(deleteagent));
  bot.use(createConversation(listagents));
  bot.use(createConversation(createrole));
  bot.use(createConversation(updaterole));
  bot.use(createConversation(listroles));
  bot.use(createConversation(deleterole));
  bot.use(createConversation(createknowleage));
  bot.use(createConversation(listknowledges));
  bot.use(createConversation(addknowlegecollection));
  bot.use(createConversation(listknowlegecollection));
  bot.use(createConversation(deleteknowlegecollection));

  // Define commands
  bot.command('start', async (ctx) => {
    await ctx.reply(`Welcome! Up and running.`)
  })

  bot.command("cancel", isAdminGuard, async (ctx) => {
    if (ctx.conversation.active()) {
      await ctx.conversation.exitAll();
    }
    await ctx.reply("Leaving.");
  });

  bot.command("bindchatagent", isAdminGuard, async (ctx) => {
    await ctx.conversation.enter("bindchatagent");
  });

  bot.command("createaction", isAdminGuard, async (ctx) => {
    await ctx.conversation.enter("createaction");
  });

  // Agent
  bot.command("createagent", isAdminGuard, async (ctx) => {
    await ctx.conversation.enter("createagent");
  });
  bot.command("updateagent", isAdminGuard, async (ctx) => {
    await ctx.conversation.enter("updateagent");
  });
  bot.command("deleteagent", isAdminGuard, async (ctx) => {
    await ctx.conversation.enter("deleteagent");
  });
  bot.command("listagents", isAdminGuard, async (ctx) => {
    await ctx.conversation.enter("listagents");
  });
  // Knowledge
  bot.command("createknowleage", isAdminGuard, async (ctx) => {
    await ctx.conversation.enter("createknowleage");
  });
  bot.command("listknowledges", isAdminGuard, async (ctx) => {
    await ctx.conversation.enter("listknowledges");
  });
  // Knowledge Collection
  bot.command("addknowlegecollection", isAdminGuard, async (ctx) => {
    await ctx.conversation.enter("addknowlegecollection");
  });
  bot.command("listknowlegecollection", isAdminGuard, async (ctx) => {
    await ctx.conversation.enter("listknowlegecollection");
  });
  bot.command("deleteknowlegecollection", isAdminGuard, async (ctx) => {
    await ctx.conversation.enter("deleteknowlegecollection");
  });
  // Role
  bot.command("createrole", isAdminGuard, async (ctx) => {
    await ctx.conversation.enter("createrole");
  });
  bot.command("updaterole", isAdminGuard, async (ctx) => {
    await ctx.conversation.enter("updaterole");
  });
  bot.command("listroles", isAdminGuard, async (ctx) => {
    await ctx.conversation.enter("listroles");
  });
  bot.command("deleterole", isAdminGuard, async (ctx) => {
    await ctx.conversation.enter("deleterole");
  });

  bot.on("message:text", async (ctx) => {
    console.log("ctx.message.text:", ctx.message.text);
    console.log("ctx.me.username:", ctx.me.username);
    const mentions = ctx.message.text.match(/@\w+/g);
    if (mentions?.includes(`@${ctx.me.username}`)) {
      const cleanText = ctx.message.text.replace(/@\w+/g, "").trim();
      ctx.message.text = cleanText
      EdgeRuntime.waitUntil(answerQuestion(ctx));
    }
  });
  return bot;
}

export { constructorBot }