import { InlineKeyboard } from 'https://deno.land/x/grammy@v1.34.0/mod.ts'

// 工具函数：等待用户输入文本
async function waitForTextInput(
  conversation: MyConversation,
  ctx: MyContext,
  promptMessage: string
): Promise<string | null> {
  await ctx.reply(promptMessage);
  const inputCtx = await conversation.waitFor(":text");
  console.log("inputCtx.message.text:", inputCtx.message.text);
  if (inputCtx.message.text.startsWith("/skip")) {
    return "/skip";
  }
  if (inputCtx.message.text.startsWith("/cancel")) {
    await ctx.reply("操作已取消");
    return null;
  }
  return inputCtx.message.text;
}

async function waitForTextInputTips(
  conversation: MyConversation,
  ctx: MyContext,
  promptMessage: string
): Promise<string | null> {
  // reply 格式化提示信息，让信息更加友好
  promptMessage = promptMessage.replace(/<b>/g, "[b]").replace(/<\/b>/g, "[/b]").replace(/<i>/g, "[i]").replace(/<\/i>/g, "[/i]");
  await ctx.reply(promptMessage);
  const inputCtx = await conversation.waitFor(":text");
  console.log("inputCtx.message.text:", inputCtx.message.text);
  if (inputCtx.message.text.startsWith("/skip")) {
    return null;
  }
  if (inputCtx.message.text.startsWith("/cancel")) {
    await ctx.reply("操作已取消");
    return null;
  }
  return inputCtx.message.text;
}

async function waitForFileInput(
  conversation: MyConversation,
  ctx: MyContext,
  promptMessage: string
): Promise<string | null> {
  await ctx.reply(promptMessage);
  const inputCtx = await conversation.waitFor(":file");
  console.log("inputCtx", inputCtx);
  const res = await inputCtx.getFile();
  console.log("res", res);
  return inputCtx.message.text;
}

// 工具函数：等待用户从键盘选择选项
async function waitForOptionSelection(
  conversation: MyConversation,
  ctx: MyContext,
  promptMessage: string,
  options: Map<string, string>,
  isAddSkip: boolean
): Promise<{ id: string; name: string } | null> {
  if (options.size === 0) {
    await ctx.reply("没有可用的选项");
    return null;
  }

  const keyboard = new InlineKeyboard();
  for (const [id, name] of options.entries()) {
    keyboard.text(name, id);
    keyboard.row();
  }
  if (isAddSkip) {
    options.set("skip", "skip");
    keyboard.row().text("skip", "skip");
  }

  const sentMessage = await ctx.reply(promptMessage, { reply_markup: keyboard });

  const response = await conversation.waitForCallbackQuery([...options.keys()], { timeout: 60_000 });

  const selectedId = response.match;
  if (selectedId == "skip") {
    await response.answerCallbackQuery(); // 反馈用户操作
    await response.api.editMessageReplyMarkup(sentMessage.chat.id, sentMessage.message_id, {
      reply_markup: undefined, // 清除按钮
    });
    return { id: "skip", name: "skip" };
  }
  const selectedName = options.get(selectedId);
  console.log("selectedName:", selectedName);
  if (selectedName) {
    // 编辑消息，移除 Inline Keyboard 或标记为已选择
    await response.api.editMessageReplyMarkup(sentMessage.chat.id, sentMessage.message_id, {
      reply_markup: undefined, // 清除按钮
    });
    // 可选：更新消息文本，标明用户选择
    await response.api.editMessageText(sentMessage.chat.id, sentMessage.message_id,
      `You choosed:${selectedName}`);
  }
  await response.answerCallbackQuery(); // 反馈用户操作
  return selectedName ? { id: selectedId, name: selectedName } : null;
}

async function waitForMoreOptionSelection(
  conversation: MyConversation,
  ctx: MyContext,
  promptMessage: string,
  options: Map<string, string>,
  isAddSkip: Boolean
): Promise<Array<{ id: string; name: string }>> {
  if (options.size === 0) {
    await ctx.reply("没有可用的选项");
    return [];
  }

  let selectedOptions = new Set<string>();

  // 构建键盘
  const getKeyboard = () => {
    const keyboard = new InlineKeyboard();
    for (const [id, name] of options.entries()) {
      const label = selectedOptions.has(id) ? `✅ ${name}` : name;
      keyboard.text(label, id);
    }
    options.set("done", "done");
    if (isAddSkip) {
      options.set("skip", "skip");
      keyboard.row().text("skip", "skip").text("done", "done");
    } else {
      keyboard.row().text("done", "done")
    }
    return keyboard;
  };

  // 发送消息
  let sentMessage = await ctx.reply(promptMessage, { reply_markup: getKeyboard() });

  while (true) {
    const response = await conversation.waitForCallbackQuery([...options.keys()], { timeout: 60000 });
    const selectedId = response.match;
    if (selectedId == "skip") {
      await response.answerCallbackQuery({ text: "seleted done!" });
      // 将所有的选项都隐藏，
      await response.api.editMessageReplyMarkup(sentMessage.chat.id, sentMessage.message_id, {
        reply_markup: undefined,
      });
      break;
    }

    // if user click "done"
    if (selectedId === "done") {
      await response.answerCallbackQuery({ text: "seleted done!" });
      // 将所有的选项都隐藏，
      await response.api.editMessageReplyMarkup(sentMessage.chat.id, sentMessage.message_id, {
        reply_markup: undefined,
      });
      const selectedLanguages = Array.from(selectedOptions).map((id) => ({
        id,
        name: options.get(id)!,
      }));
      await response.api.editMessageText(sentMessage.chat.id, sentMessage.message_id,
        `You selected:${selectedLanguages.map((lang) => lang.name).join(", ")}`);
      break;
    }

    // 切换选中状态
    if (selectedOptions.has(selectedId)) {
      selectedOptions.delete(selectedId);
    } else {
      selectedOptions.add(selectedId);
    }

    // 更新键盘显示状态
    await response.answerCallbackQuery(); // 反馈用户操作
    await response.api.editMessageReplyMarkup(sentMessage.chat.id, sentMessage.message_id, {
      reply_markup: getKeyboard(),
    });
  }

  // 返回结果
  const result = Array.from(selectedOptions).map((id) => ({
    id,
    name: options.get(id)!,
  }));
  return result;
}

export { waitForTextInput, waitForOptionSelection, waitForMoreOptionSelection, waitForTextInputTips, waitForFileInput };