// Follow this setup guide to integrate the Deno language server with your editor:
// https://deno.land/manual/getting_started/setup_your_environment
// This enables autocomplete, go to definition, etc.

console.log(`Function "telegram-bot" up and running!`)

import "jsr:@supabase/functions-js/edge-runtime.d.ts";
import { webhookCallback } from 'https://deno.land/x/grammy@v1.34.0/mod.ts'
import { constructorBot } from "./bot.ts";

Deno.serve(async (req) => {
  try {

    const url = new URL(req.url)
    if (url.searchParams.get('secret') !== Deno.env.get('FUNCTION_SECRET_TEST')) {
      return new Response('not allowed', { status: 405 })
    }

    const user = url.searchParams.get('user');
    const supportBot = JSON.parse(Deno.env.get('SUPPORT_BOT') || '[]');
    if (!supportBot.includes(user)) {
      return new Response('not allowed', { status: 405 })
    }

    // 检查请求体
    if (req.body === null) {
      return new Response('Empty request body', { status: 400 })
    }

    const SUPPORT_BOT_TOKEN_ENV = Deno.env.get('SUPPORT_BOT_TOKEN') || '';

    const supportBotToken = SUPPORT_BOT_TOKEN_ENV.split(";").reduce((acc, pair) => {
      const [key, value] = pair.split("~");
      acc[key] = value;
      return acc;
    }, {});

    console.log("supportBotToken:", supportBotToken);

    const botToken = supportBotToken[user];

    console.log("botToken:", botToken);

    const bot = await constructorBot(botToken);

    const handleUpdate = webhookCallback(bot, 'std/http');

    const response = await handleUpdate(req)
    if (!response) {
      return new Response('Invalid update', { status: 400 })
    }

    return response
  } catch (err) {
    console.error(err)
    return new Response(JSON.stringify({ error: err.message }), {
      status: 500,
      headers: { 'Content-Type': 'application/json' }
    });
  }
})