// SPDX-License-Identifier: MIT
pragma solidity ^0.8.0;

import "./ISQLSync.sol";
import "./SQLSync.sol"; // 假设这是你的具体实现文件

contract SQLSyncFactory {
    // 记录所有创建出来的实例
    mapping(address => bool) public isValidInstance;
    address[] public allInstances;

    event InstanceCreated(address indexed owner, address indexed instance);

    /**
     * @notice 创建一个新的 SQLSync 实例
     * @return instance 新合约地址
     */
    function createInstance() external returns (address instance) {
        // 部署新的 SQLSync 合约
        // 注意：SQLSync 的构造函数需要能够接收 owner，或者在这之后 transferOwnership
        SQLSync newContract = new SQLSync(msg.sender);

        instance = address(newContract);

        isValidInstance[instance] = true;
        allInstances.push(instance);

        emit InstanceCreated(msg.sender, instance);
    }

    /**
     * @notice 获取实例总数
     */
    function getInstanceCount() external view returns (uint256) {
        return allInstances.length;
    }
}
