#!/bin/bash

# ChainSQL 数据库重置脚本
# 当重启 Hardhat 节点后，需要重置同步游标

echo "🔄 Resetting ChainSQL database cursors..."

# 重置游标
docker exec chainsql-db psql -U chainsql -d chainsql -c "DELETE FROM _chainsql_cursor;"
docker exec chainsql-db psql -U chainsql -d chainsql -c "DELETE FROM _chainsql_instances;"

echo "✅ Database reset complete!"
echo ""
echo "📊 Current status:"
docker exec chainsql-db psql -U chainsql -d chainsql -c "SELECT * FROM _chainsql_cursor;"
docker exec chainsql-db psql -U chainsql -d chainsql -c "SELECT * FROM _chainsql_instances;"
echo ""
echo "现在可以重新启动 ChainSQL 了："
echo "  go run cmd/main.go"
