#!/bin/bash

# ChainSQL 停止脚本

echo "🛑 Stopping ChainSQL services..."

# 停止 ChainSQL
if [ -f chainsql.pid ]; then
    PID=$(cat chainsql.pid)
    if ps -p $PID > /dev/null; then
        kill $PID
        echo "✅ ChainSQL stopped (PID: $PID)"
    fi
    rm chainsql.pid
fi

# 停止 Hardhat
if [ -f hardhat.pid ]; then
    PID=$(cat hardhat.pid)
    if ps -p $PID > /dev/null; then
        kill $PID
        echo "✅ Hardhat node stopped (PID: $PID)"
    fi
    rm hardhat.pid
fi

# 停止 Docker 服务（可选）
read -p "Stop PostgreSQL (Docker)? (y/N): " -n 1 -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
    docker-compose down
    echo "✅ PostgreSQL stopped"
fi

echo "✅ All services stopped"
