#!/bin/bash

# ChainSQL 手动启动指南
# 如果自动脚本有问题，请按照以下步骤手动启动

echo "📚 ChainSQL 手动启动步骤"
echo "========================"
echo ""

echo "步骤 1: 启动 PostgreSQL"
echo "----------------------"
echo "docker-compose up -d postgres"
echo ""
echo "等待 5 秒让数据库启动..."
echo ""

echo "步骤 2: 安装 Hardhat 依赖（首次运行）"
echo "-----------------------------------"
echo "cd hardhat"
echo "npm install"
echo "cd .."
echo ""

echo "步骤 3: 启动 Hardhat 节点（新终端）"
echo "--------------------------------"
echo "cd hardhat"
echo "npx hardhat node"
echo ""
echo "保持这个终端运行！"
echo ""

echo "步骤 4: 部署合约（新终端）"
echo "----------------------"
echo "cd hardhat"
echo "npm run deploy"
echo ""
echo "记录输出的 factory_address"
echo ""

echo "步骤 5: 更新配置"
echo "---------------"
echo "编辑 configs/config.yaml，填入:"
echo "  factory_address: \"<从步骤4获取的地址>\""
echo ""

echo "步骤 6: 启动 ChainSQL（新终端）"
echo "----------------------------"
echo "make build"
echo "./bin/chainsql"
echo ""

echo "步骤 7: 运行集成测试（新终端）"
echo "----------------------------"
echo "cd hardhat"
echo "node scripts/integration-test.js"
echo ""

echo "✅ 完成！"
echo ""
echo "查看服务状态:"
echo "  curl http://localhost:8080/health"
echo "  curl http://localhost:8080/metrics"
echo ""
