package core

import (
	"context"

	"github.com/ethereum/go-ethereum/common"
)

// EventHandler 定义了处理业务逻辑（SQL执行）的接口
// 这使得 DataListener 不需要关心底层是 Postgres 还是 MySQL，也方便 Mock 测试
type EventHandler interface {
	EnsureSchema(ctx context.Context, contractAddr string) error

	HandleTableCreated(ctx context.Context, contractAddr string, tableName string, columns []struct {
		Name         string
		SqlType      string
		IsPrimaryKey bool
	}) error

	HandleDataInserted(ctx context.Context, contractAddr string, tableName string, columns []string, values []string) error
}

// ContractProvider 定义了获取目标合约列表的接口
type ContractProvider interface {
	GetContracts() []common.Address
}
