#!/bin/bash
# scripts/clean-schemas.sh

echo "🗑️  Cleaning ChainSQL schemas..."

# 删除所有 0x 开头的 schema
docker exec chainsql-db psql -U chainsql -d chainsql -c \
  "DO \$\$ 
   DECLARE 
     r RECORD;
   BEGIN
     FOR r IN SELECT schema_name FROM information_schema.schemata WHERE schema_name LIKE '0x%'
     LOOP
       RAISE NOTICE 'Dropping schema: %', r.schema_name;
       EXECUTE 'DROP SCHEMA IF EXISTS \"' || r.schema_name || '\" CASCADE';
     END LOOP;
   END \$\$;"

echo "✅ All ChainSQL schemas cleaned!"

# 重置游标
sh scripts/reset-db.sh