#!/bin/bash
# scripts/docker-build.sh
# Docker 镜像构建脚本

set -e

# 颜色输出
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

echo -e "${GREEN}🐳 Building ChainSQL Docker Image${NC}"

# 获取版本信息
VERSION=${VERSION:-$(git describe --tags --always 2>/dev/null || echo "dev")}
BUILD_TIME=$(date -u +"%Y-%m-%dT%H:%M:%SZ")
GIT_COMMIT=$(git rev-parse --short HEAD 2>/dev/null || echo "unknown")

echo -e "${YELLOW}Version: ${VERSION}${NC}"
echo -e "${YELLOW}Build Time: ${BUILD_TIME}${NC}"
echo -e "${YELLOW}Git Commit: ${GIT_COMMIT}${NC}"

# 构建镜像
docker build \
  --build-arg VERSION="${VERSION}" \
  --build-arg BUILD_TIME="${BUILD_TIME}" \
  --tag "chainsql:${VERSION}" \
  --tag "chainsql:latest" \
  .

echo -e "${GREEN}✅ Build completed successfully!${NC}"
echo -e "${YELLOW}Image tags:${NC}"
echo -e "  - chainsql:${VERSION}"
echo -e "  - chainsql:latest"

# 显示镜像信息
echo -e "\n${YELLOW}Image details:${NC}"
docker images chainsql --format "table {{.Repository}}\t{{.Tag}}\t{{.Size}}\t{{.CreatedAt}}"
