#!/bin/bash
# scripts/docker-logs.sh
# 查看 Docker 日志的便捷脚本

SERVICE=${1:-chainsql}
LINES=${2:-100}

case "$SERVICE" in
    chainsql|app)
        docker-compose logs -f --tail=$LINES chainsql
        ;;
    postgres|db)
        docker-compose logs -f --tail=$LINES postgres
        ;;
    all)
        docker-compose logs -f --tail=$LINES
        ;;
    *)
        echo "Usage: $0 [chainsql|postgres|all] [lines]"
        echo "Examples:"
        echo "  $0 chainsql 50    # Show last 50 lines of chainsql logs"
        echo "  $0 postgres       # Show last 100 lines of postgres logs"
        echo "  $0 all            # Show logs from all services"
        exit 1
        ;;
esac
