package common

import (
	metatypes "github.com/CaduceusMetaverseProtocol/MetaTypes/types"
	ethcmn "github.com/ethereum/go-ethereum/common"
	"math/big"
)

func FromBigInt(b *big.Int) *metatypes.BigInt {
	n := metatypes.NewBigInt(0)
	if b != nil {
		n.Set(b)
	}
	return n
}

func ToBigInt(b *metatypes.BigInt) *big.Int {
	return b.GetInt()
}

func ToHash(d []byte) *metatypes.Hash {
	h := new(metatypes.Hash)
	h.SetBytes(d)
	return h
}

func ToEthAddress(d *metatypes.Address) *ethcmn.Address {
	addr := new(ethcmn.Address)
	if d != nil {
		addr.SetBytes(d.Bytes())
	}
	return addr
}

func FromEthAddress(e *ethcmn.Address) *metatypes.Address {
	addr := new(metatypes.Address)
	addr.SetBytes(e.Bytes())
	return addr
}
