package txcache

import (
	"strings"
	"sync"
)

var (
	gtxCache = &TxCache{
		cache: make(map[string]string),
	}
)

type TxCache struct {
	cache map[string]string
	mux   sync.RWMutex
}

func Add(txHash string, address string) {
	gtxCache.mux.Lock()
	defer gtxCache.mux.Unlock()
	gtxCache.cache[txHash] = address
}

func CompareAddress(txHash string, newer string) bool {
	gtxCache.mux.RLock()
	defer gtxCache.mux.RUnlock()
	o, exist := gtxCache.cache[txHash]
	if !exist {
		return false
	}
	return strings.Compare(newer, o) == 0
}

func GetFromAddr(txHash string) (string, bool) {
	gtxCache.mux.RLock()
	defer gtxCache.mux.RUnlock()
	o, exist := gtxCache.cache[txHash]
	return o, exist
}
