package benchmark_test

import (
	"fmt"
	"math"
	"math/big"
	"sort"

	"testing"

	"github.com/ethereum/go-ethereum/crypto"
)

//date &&  go test -v -run BenchmarkHello -bench=BenchmarkHello   -benchtime=3s   -benchmem && date
//go test   -v -run  BenchmarkAnyTxEth -bench BenchmarkRepeated -benchmem  -count 10 | tee RepeatedTxEthAsAny.txt

// go test   -v -run  BenchmarkHello -bench BenchmarkHello -benchmem  -count 10 | tee RepeatedTxEthAsAny.txt
func BenchmarkHello(b *testing.B) {
	// b.Log(b.N)

	// //b.Logf("begin time: %s \n", time.Now())

	// b.ResetTimer()

	local, _ := crypto.HexToECDSA("FD5CC6F5E7E2805E920AC5DC83D5AF1106F9C92F0C04F9D5E1FD4261B4B4464A")
	// publicKey := local.Public()
	// publicKeyECDSA, _ := publicKey.(*ecdsa.PublicKey)
	//fromAddr := crypto.PubkeyToAddress(*publicKeyECDSA)

	remote, _ := crypto.GenerateKey()

	tx, err := pricedTransaction(crypto.PubkeyToAddress(remote.PublicKey), 0, 100000, big.NewInt(1), local)

	if err != nil {
		b.Fatal(err)
	}
	for i := 0; i < b.N; i++ {
		//b.Logf("idx %d time: %s \n", i, time.Now())
		fmt.Sprintf("%v", tx)
	}

	//b.StopTimer()
	//b.Logf("end time: %s \n", time.Now())

	// var compares int64
	// for i := 0; i < b.N; i++ {
	// 	s := []int{5, 4, 3, 2, 1}
	// 	sort.Slice(s, func(i, j int) bool {
	// 		compares++
	// 		return s[i] < s[j]
	// 	})
	// }
	// This metric is per-operation, so divide by b.N and
	// report it as a "/op" unit.
	// b.ReportMetric(float64(compares)/float64(b.N), "compares/op")
}

func BenchmarkCalculate(b *testing.B) {
	for i := 0; i < b.N; i++ {
		Calculate(2)
	}
}

// Calculate returns x + 2.
func Calculate(x int) (result int) {
	result = x + 2
	return result
}

func primeNumbers(max int) []int {
	var primes []int

	for i := 2; i < max; i++ {
		isPrime := true

		for j := 2; j <= int(math.Sqrt(float64(i))); j++ {
			if i%j == 0 {
				isPrime = false
				break
			}
		}

		if isPrime {
			primes = append(primes, i)
		}
	}

	return primes
}

var num = 1000

// func BenchmarkPrimeNumbers(b *testing.B) {
// 	for i := 0; i < b.N; i++ {
// 		primeNumbers(num)
// 	}
// }

var table = []struct {
	input int
}{
	{input: 100},
	{input: 1000},
	{input: 74382},
	{input: 382399},
}

func BenchmarkPrimeNumbers(b *testing.B) {
	for _, v := range table {
		b.Run(fmt.Sprintf("input_size_%d", v.input), func(b *testing.B) {
			for i := 0; i < b.N; i++ {
				//primeNumbers(v.input)
				sieveOfEratosthenes(v.input)
			}
		})
	}
}

func sieveOfEratosthenes(max int) []int {
	b := make([]bool, max)

	var primes []int

	for i := 2; i < max; i++ {
		if b[i] {
			continue
		}

		primes = append(primes, i)

		for k := i * i; k < max; k += i {
			b[k] = true
		}
	}

	return primes
}

// main_test.go
func BenchmarkSieveOfErastosthenes(b *testing.B) {
	for _, v := range table {
		b.Run(fmt.Sprintf("input_size_%d", v.input), func(b *testing.B) {
			for i := 0; i < b.N; i++ {
				sieveOfEratosthenes(v.input)
			}
		})
	}
}

func TestReportMetric(t *testing.T) {
	res := testing.Benchmark(func(b *testing.B) {
		b.ReportMetric(12345, "ns/op")
		b.ReportMetric(0.2, "frobs/op")
	})
	// Test built-in overriding.
	if res.NsPerOp() != 12345 {
		t.Errorf("NsPerOp: expected %v, actual %v", 12345, res.NsPerOp())
	}
	// Test stringing.
	res.N = 1 // Make the output stable
	want := "       1\t     12345 ns/op\t         0.2000 frobs/op"
	if want != res.String() {
		t.Errorf("expected %q, actual %q", want, res.String())
	}
}

// go test   -v -run  BenchmarkMetric -bench BenchmarkMetric -benchmem
func BenchmarkMetric(b *testing.B) {

	var compares int64
	for i := 0; i < b.N; i++ {
		s := []int{5, 4, 3, 2, 1}
		sort.Slice(s, func(i, j int) bool {
			compares++
			return s[i] < s[j]
		})

	}

	// This metric is per-operation, so divide by b.N and
	// report it as a "/op" unit.
	//b.ReportMetric(float64(compares)/float64(b.N), "compares/op")

	// This metric is per-operation, so divide by b.N and
	// report it as a "/op" unit.
	//b.ReportMetric(float64(compares)/float64(b.N), "compares/op")
	// This metric is per-time, so divide by b.Elapsed and
	// report it as a "/ns" unit.

	//b.ReportMetric(float64(compares)/float64(b.Elapsed().Nanoseconds()), "compares/ns")
}
func ExampleB_ReportMetric() {
	// This reports a custom benchmark metric relevant to a
	// specific algorithm (in this case, sorting).
	testing.Benchmark(func(b *testing.B) {
		var compares int64
		for i := 0; i < b.N; i++ {
			s := []int{5, 4, 3, 2, 1}
			sort.Slice(s, func(i, j int) bool {
				compares++
				return s[i] < s[j]
			})
		}
		// This metric is per-operation, so divide by b.N and
		// report it as a "/op" unit.
		b.ReportMetric(float64(compares)/float64(b.N), "compares/op")
	})
}

// func TestBRun(t *T) {
// 	work := func(b *B) {
// 		for i := 0; i < b.N; i++ {
// 			time.Sleep(time.Nanosecond)
// 		}
// 	}
// 	testCases := []struct {
// 		desc   string
// 		failed bool
// 		chatty bool
// 		output string
// 		f      func(*B)
// 	}{{
// 		desc: "simulate sequential run of subbenchmarks.",
// 		f: func(b *B) {
// 			b.Run("", func(b *B) { work(b) })
// 			time1 := b.result.NsPerOp()
// 			b.Run("", func(b *B) { work(b) })
// 			time2 := b.result.NsPerOp()
// 			if time1 >= time2 {
// 				t.Errorf("no time spent in benchmark t1 >= t2 (%d >= %d)", time1, time2)
// 			}
// 		},
// 	}, {
// 		desc: "bytes set by all benchmarks",
// 		f: func(b *B) {
// 			b.Run("", func(b *B) { b.SetBytes(10); work(b) })
// 			b.Run("", func(b *B) { b.SetBytes(10); work(b) })
// 			if b.result.Bytes != 20 {
// 				t.Errorf("bytes: got: %d; want 20", b.result.Bytes)
// 			}
// 		},
// 	}, {
// 		desc: "bytes set by some benchmarks",
// 		// In this case the bytes result is meaningless, so it must be 0.
// 		f: func(b *B) {
// 			b.Run("", func(b *B) { b.SetBytes(10); work(b) })
// 			b.Run("", func(b *B) { work(b) })
// 			b.Run("", func(b *B) { b.SetBytes(10); work(b) })
// 			if b.result.Bytes != 0 {
// 				t.Errorf("bytes: got: %d; want 0", b.result.Bytes)
// 			}
// 		},
// 	}, {
// 		desc:   "failure carried over to root",
// 		failed: true,
// 		output: "--- FAIL: root",
// 		f:      func(b *B) { b.Fail() },
// 	}, {
// 		desc:   "skipping without message, chatty",
// 		chatty: true,
// 		output: "--- SKIP: root",
// 		f:      func(b *B) { b.SkipNow() },
// 	}, {
// 		desc:   "chatty with recursion",
// 		chatty: true,
// 		f: func(b *B) {
// 			b.Run("", func(b *B) {
// 				b.Run("", func(b *B) {})
// 			})
// 		},
// 	}, {
// 		desc: "skipping without message, not chatty",
// 		f:    func(b *B) { b.SkipNow() },
// 	}, {
// 		desc:   "skipping after error",
// 		failed: true,
// 		output: `
// --- FAIL: root
//     sub_test.go:NNN: an error
//     sub_test.go:NNN: skipped`,
// 		f: func(b *B) {
// 			b.Error("an error")
// 			b.Skip("skipped")
// 		},
// 	}, {
// 		desc: "memory allocation",
// 		f: func(b *B) {
// 			const bufSize = 256
// 			alloc := func(b *B) {
// 				var buf [bufSize]byte
// 				for i := 0; i < b.N; i++ {
// 					_ = append([]byte(nil), buf[:]...)
// 				}
// 			}
// 			b.Run("", func(b *B) {
// 				alloc(b)
// 				b.ReportAllocs()
// 			})
// 			b.Run("", func(b *B) {
// 				alloc(b)
// 				b.ReportAllocs()
// 			})
// 			// runtime.MemStats sometimes reports more allocations than the
// 			// benchmark is responsible for. Luckily the point of this test is
// 			// to ensure that the results are not underreported, so we can
// 			// simply verify the lower bound.
// 			if got := b.result.MemAllocs; got < 2 {
// 				t.Errorf("MemAllocs was %v; want 2", got)
// 			}
// 			if got := b.result.MemBytes; got < 2*bufSize {
// 				t.Errorf("MemBytes was %v; want %v", got, 2*bufSize)
// 			}
// 		},
// 	}, {
// 		desc: "cleanup is called",
// 		f: func(b *B) {
// 			var calls, cleanups, innerCalls, innerCleanups int
// 			b.Run("", func(b *B) {
// 				calls++
// 				b.Cleanup(func() {
// 					cleanups++
// 				})
// 				b.Run("", func(b *B) {
// 					b.Cleanup(func() {
// 						innerCleanups++
// 					})
// 					innerCalls++
// 				})
// 				work(b)
// 			})
// 			if calls == 0 || calls != cleanups {
// 				t.Errorf("mismatched cleanups; got %d want %d", cleanups, calls)
// 			}
// 			if innerCalls == 0 || innerCalls != innerCleanups {
// 				t.Errorf("mismatched cleanups; got %d want %d", cleanups, calls)
// 			}
// 		},
// 	}, {
// 		desc:   "cleanup is called on failure",
// 		failed: true,
// 		f: func(b *B) {
// 			var calls, cleanups int
// 			b.Run("", func(b *B) {
// 				calls++
// 				b.Cleanup(func() {
// 					cleanups++
// 				})
// 				b.Fatalf("failure")
// 			})
// 			if calls == 0 || calls != cleanups {
// 				t.Errorf("mismatched cleanups; got %d want %d", cleanups, calls)
// 			}
// 		},
// 	}}
// 	for _, tc := range testCases {
// 		t.Run(tc.desc, func(t *T) {
// 			var ok bool
// 			buf := &bytes.Buffer{}
// 			// This is almost like the Benchmark function, except that we override
// 			// the benchtime and catch the failure result of the subbenchmark.
// 			root := &B{
// 				common: common{
// 					signal: make(chan bool),
// 					name:   "root",
// 					w:      buf,
// 				},
// 				benchFunc: func(b *B) { ok = b.Run("test", tc.f) }, // Use Run to catch failure.
// 				benchTime: durationOrCountFlag{d: 1 * time.Microsecond},
// 			}
// 			if tc.chatty {
// 				root.chatty = newChattyPrinter(root.w)
// 			}
// 			root.runN(1)
// 			if ok != !tc.failed {
// 				t.Errorf("%s:ok: got %v; want %v", tc.desc, ok, !tc.failed)
// 			}
// 			if !ok != root.Failed() {
// 				t.Errorf("%s:root failed: got %v; want %v", tc.desc, !ok, root.Failed())
// 			}
// 			// All tests are run as subtests
// 			if root.result.N != 1 {
// 				t.Errorf("%s: N for parent benchmark was %d; want 1", tc.desc, root.result.N)
// 			}
// 			got := strings.TrimSpace(buf.String())
// 			want := strings.TrimSpace(tc.output)
// 			re := makeRegexp(want)
// 			if ok, err := regexp.MatchString(re, got); !ok || err != nil {
// 				t.Errorf("%s:output:\ngot:\n%s\nwant:\n%s", tc.desc, got, want)
// 			}
// 		})
// 	}
// }
