package main

import (
	"context"
	"fmt"
	"net"

	//metabase "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/base/v1"
	metacrypter "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/crypter/v1"
	metanebula "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/nebula/v1"
	metap2p "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/p2p/v1"
	metaring "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/ring/v1"
	metasentry "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/sentry/v1"
	txchecker "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/txchecker/v1"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
	"google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/types/known/anypb"
)

type P2PServer struct {
	metap2p.UnimplementedP2PServiceServer
}

type NebulaServer struct {
	metanebula.UnimplementedNebulaServiceServer
}

type SentryServer struct {
	metasentry.UnimplementedSentryServiceServer
}

type TxCheckServer struct {
	txchecker.UnimplementedTxCheckerServiceServer
}

type RingServer struct {
	metaring.UnimplementedRingServiceServer
}

type server struct {
	metacrypter.UnimplementedCrypterServiceServer
}

//	func (*server) Sign(ctx context.Context, req *metacrypter.SignRequest) (*metacrypter.SignResponse, error) {
//		return nil, status.Errorf(codes.Unimplemented, "method Sign not implemented")
//	}
//
//	func (*server) Verify(ctx context.Context, req *metacrypter.VerifyRequest) (*metacrypter.VerifyResponse, error) {
//		return nil, status.Errorf(codes.Unimplemented, "method Verify not implemented")
//	}
//
//	func (*server) Recover(ctx context.Context, req *metacrypter.RecoverRequest) (*metacrypter.RecoverResponse, error) {
//		return nil, status.Errorf(codes.Unimplemented, "method Recover not implemented")
//	}
func (*server) BatchSign(ctx context.Context, req *metacrypter.BatchSignRequest) (*metacrypter.BatchSignResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchSign not implemented")
}
func (*server) BatchVerify(ctx context.Context, req *metacrypter.BatchVerifyRequest) (*metacrypter.BatchVerifyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchVerify not implemented")
}
func (*server) BatchRecover(ctx context.Context, req *metacrypter.BatchRecoverRequest) (*metacrypter.BatchRecoverResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchRecover not implemented")
}

func main() {
	lis, err := net.Listen("tcp", ":8972")
	if err != nil {
		fmt.Printf("failed to listen: %v", err)
		return
	}

	//ethTx := metabase.EthTx{}

	//var checkTx metabase.EthTx

	//ethTxAsAny, err := pbany(ethTx)

	if err != nil {
		fmt.Println(err.Error())
		return
	}

	//checkTx.Tx = ethTxAsAny

	s := grpc.NewServer()                                  // create grpc server
	metacrypter.RegisterCrypterServiceServer(s, &server{}) // register service

	err = s.Serve(lis)
	if err != nil {
		fmt.Printf("failed to serve: %v", err)
		return
	}
}

func pbany(v interface{}) (*anypb.Any, error) {
	pv, ok := v.(proto.Message)
	if !ok {
		return &anypb.Any{}, fmt.Errorf("%v is not proto.Message", pv)
	}

	return anypb.New(pv)
}
