package crypto

import (
	"github.com/CaduceusMetaverseProtocol/MetaCryptor/common"
	basev1 "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/base/v1"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/crypto"
	"math/big"
)

func SignTx(pk []byte, tx *basev1.MetaTxBase, chainid *big.Int) error {
	txdata := &types.LegacyTx{
		Nonce:    tx.Nonce,
		GasPrice: common.ToBigInt(tx.GasPrice),
		Gas:      tx.Gas,
		To:       common.ToEthAddress(tx.To),
		Value:    common.ToBigInt(tx.Value),
		Data:     tx.Data,
	}
	ntx := types.NewTx(txdata)
	signer := types.NewEIP155Signer(chainid)

	privk, err := crypto.ToECDSA(pk)
	if err != nil {
		return err
	}
	signedTx, err := types.SignTx(ntx, signer, privk)
	if err != nil {
		return err
	}
	v, r, s := signedTx.RawSignatureValues()
	tx.R = common.FromBigInt(r)
	tx.S = common.FromBigInt(s)
	tx.V = common.FromBigInt(v)

	return nil
}
