package service

import (
	"context"
	"github.com/CaduceusMetaverseProtocol/MetaCryptor/common/log"
	"github.com/CaduceusMetaverseProtocol/MetaCryptor/worker"
	metacrypter "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/crypter/v1"
	metatypes "github.com/CaduceusMetaverseProtocol/MetaTypes/types"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

type CrypterServer struct {
	worker *worker.Worker
	metacrypter.UnimplementedCrypterServiceServer
}

func (s *CrypterServer) BatchSign(ctx context.Context, req *metacrypter.BatchSignRequest) (*metacrypter.BatchSignResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchSign not implemented")
}
func (s *CrypterServer) BatchVerify(ctx context.Context, req *metacrypter.BatchVerifyRequest) (*metacrypter.BatchVerifyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchVerify not implemented")
}
func (s *CrypterServer) BatchRecover(ctx context.Context, req *metacrypter.BatchRecoverRequest) (*metacrypter.BatchRecoverResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchRecover not implemented")
}

func (s *CrypterServer) BatchSignTx(ctx context.Context, req *metacrypter.BatchSignTxRequest) (*metacrypter.BatchSignTxResponse, error) {
	log.Info("server get batch recover tx request")
	signedTxs := s.worker.BatchSignTx(req.RawTx, req.Private)

	response := new(metacrypter.BatchSignTxResponse)
	response.SignedTx = signedTxs

	return response, nil
}

func (s *CrypterServer) BatchRecoverTx(ctx context.Context, req *metacrypter.BatchRecoverTxRequest) (*metacrypter.BatchRecoverTxResponse, error) {
	//tasks := make([]*XTaskSecp256k1RPubkey, len(req.RawTx))
	//big8 := big.NewInt(8)
	log.Info("server get batch recover tx request")
	froms := s.worker.BatchRecoverTx(req.RawTx)

	response := new(metacrypter.BatchRecoverTxResponse)
	response.RecoverdTx = req.RawTx

	for i := 0; i < len(response.RecoverdTx); i++ {
		a := metatypes.BytesToAddress(froms[i])
		response.RecoverdTx[i].From = &a
	}

	return response, nil
}

func RegisterCrypter(server *grpc.Server, worker *worker.Worker) {
	metacrypter.RegisterCrypterServiceServer(server, &CrypterServer{worker: worker})
}
