// +build opencl

package opencl

/*
#cgo CFLAGS: -I.
#cgo LDFLAGS: -L . -loclsp -lOpenCL
#include "oclsp.h"
*/
import "C"
import (
	"github.com/CaduceusMetaverseProtocol/MetaCryptor/xecc/types"
	"sync"
	"time"
)

const (
	defaultMaxBuff = 100000
	defaultMaxIdle = time.Millisecond * 300
	defaultMaxWait = time.Second * 2
)

type basetask struct {
	rwmux  sync.RWMutex
	busy   bool
	lastm  time.Time
	firstm time.Time
	tasks  []*types.TaskWithReport
}

func (b basetask) add(task *types.TaskWithReport) {
	b.rwmux.Lock()
	defer b.rwmux.Unlock()
	if len(b.tasks) == 0 {
		b.firstm = time.Now()
	}
	b.tasks = append(b.tasks, task)
	b.lastm = time.Now()
}

func (b basetask) len() int {
	b.rwmux.RLock()
	defer b.rwmux.RUnlock()
	return len(b.tasks)
}

func (b basetask) ready() bool {
	b.rwmux.RLock()
	defer b.rwmux.RUnlock()

	return len(b.tasks) >= defaultMaxBuff || // buffer is full
		(len(b.tasks) > 0 && time.Now().After(b.firstm.Add(defaultMaxWait))) || // first item wait timeout
		(len(b.tasks) > 0 && time.Now().After(b.lastm.Add(defaultMaxIdle))) // task idle timeout
}

func newBaseTask() *basetask {
	return &basetask{
		tasks: make([]*types.TaskWithReport, 0),
	}
}
