package main

import (
	"context"
	"github.com/CaduceusMetaverseProtocol/MetaCryptor/common"
	"github.com/CaduceusMetaverseProtocol/MetaCryptor/common/log"
	basetype "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/base/v1"
	metacrypter "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/crypter/v1"
	"google.golang.org/grpc"
	"google.golang.org/grpc/credentials/insecure"
	"math/big"
)

func main() {
	client, err := grpc.Dial("127.0.0.1:38001", grpc.WithTransportCredentials(insecure.NewCredentials()))
	if err != nil {
		log.Error("dial server failed", err)
	}
	accounts := common.CreateAccounts(1)
	log.Info("account address is ", accounts[0].Address.String())
	tmptx := accounts[0].MakeInitTx(big.NewInt(100))

	crypterclient := metacrypter.NewCrypterServiceClient(client)

	signTxReq := new(metacrypter.BatchSignTxRequest)
	signTxReq.RawTx = make([]*basetype.MetaTxBase, 0)
	{
		var err error
		stx := &basetype.MetaTxBase{
			TxHash:   common.ToHash(tmptx.Hash().Bytes()),
			TxType:   1,
			ChainId:  common.FromBigInt(big.NewInt(100)),
			Gas:      tmptx.Gas(),
			GasPrice: common.FromBigInt(tmptx.GasPrice()),
			Value:    common.FromBigInt(tmptx.Value()),
			Data:     tmptx.Data(),
			Nonce:    tmptx.Nonce(),
			To:       common.FromEthAddress(tmptx.To()),
		}
		signTxReq.RawTx = append(signTxReq.RawTx, stx)
		signTxReq.Private = common.FromHex(accounts[0].Private)

		signRes, err := crypterclient.BatchSignTx(context.Background(), signTxReq)
		if err != nil {
			log.Errorf("batch sign tx failed with error:(%s)", err)
			return
		}
		recoverReq := new(metacrypter.BatchRecoverTxRequest)
		recoverReq.RawTx = signRes.SignedTx
		recoverRes, err := crypterclient.BatchRecoverTx(context.Background(), recoverReq, grpc.EmptyCallOption{})
		if err != nil {
			log.Error("batch recover batch signed tx failed", err)
		} else {
			log.Info("recover batch signed tx got from ", recoverRes.RecoverdTx[0].From)
		}
	}
	{

		req := new(metacrypter.BatchRecoverTxRequest)
		req.RawTx = make([]*basetype.MetaTxBase, 0)
		v, r, s := tmptx.RawSignatureValues()
		log.WithField("txhash", tmptx.Hash().String()).Info("txhash")
		log.WithField("r", common.Bytes2Hex(r.Bytes())).Info("tx r")
		log.WithField("s", common.Bytes2Hex(s.Bytes())).Info("tx s")
		log.WithField("v", common.Bytes2Hex(v.Bytes())).Info("tx v")
		rtx := &basetype.MetaTxBase{
			TxHash:   common.ToHash(tmptx.Hash().Bytes()),
			TxType:   1,
			ChainId:  common.FromBigInt(big.NewInt(100)),
			Gas:      tmptx.Gas(),
			GasPrice: common.FromBigInt(tmptx.GasPrice()),
			Value:    common.FromBigInt(tmptx.Value()),
			Data:     tmptx.Data(),
			Nonce:    tmptx.Nonce(),
			To:       common.FromEthAddress(tmptx.To()),
			R:        common.FromBigInt(r),
			S:        common.FromBigInt(s),
			V:        common.FromBigInt(v),
		}
		req.RawTx = append(req.RawTx, rtx)
		res, err := crypterclient.BatchRecoverTx(context.Background(), req, grpc.EmptyCallOption{})
		if err != nil {
			log.Error("batch recover tx failed", err)
		}
		log.Info("recover got from ", res.RecoverdTx[0].From)
	}

}
