package crypto

import (
	"github.com/CaduceusMetaverseProtocol/MetaCryptor/common"
	basev1 "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/base/v1"
	"github.com/ethereum/go-ethereum/core/types"
	"math/big"
)

func SignedHash(tx *basev1.MetaTxBase, chainid *big.Int) []byte {
	txdata := &types.LegacyTx{
		Nonce:    tx.Nonce,
		GasPrice: common.ToBigInt(tx.GasPrice),
		Gas:      tx.Gas,
		To:       common.ToEthAddress(tx.To),
		Value:    common.ToBigInt(tx.Value),
		Data:     tx.Data,
		V:        common.ToBigInt(tx.V),
		R:        common.ToBigInt(tx.R),
		S:        common.ToBigInt(tx.S),
	}
	ntx := types.NewTx(txdata)
	signer := types.NewEIP155Signer(chainid)
	return signer.Hash(ntx).Bytes()
}
