package main

import (
	"context"
	"fmt"
	"github.com/CaduceusMetaverseProtocol/MetaCryptor/common"
	"github.com/CaduceusMetaverseProtocol/MetaCryptor/common/log"
	"github.com/CaduceusMetaverseProtocol/MetaCryptor/service"
	"github.com/CaduceusMetaverseProtocol/MetaCryptor/xecc"
	basetype "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/base/v1"
	metacrypter "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/crypter/v1"
	"google.golang.org/grpc"
	"google.golang.org/grpc/credentials/insecure"
	"math/big"
	"net"
	"time"
)

func test() {
	time.Sleep(time.Second * 4)
	client, err := grpc.Dial("127.0.0.1:38001", grpc.WithTransportCredentials(insecure.NewCredentials()))
	if err != nil {
		log.Error("dial server failed", err)
	}
	accounts := CreateAccounts(1)
	log.Info("account address is ", accounts[0].Address.String())
	tx := accounts[0].MakeInitTx(big.NewInt(100))
	crypterclient := metacrypter.NewCrypterServiceClient(client)
	req := new(metacrypter.BatchRecoverTxRequest)
	req.RawTx = make([]*basetype.MetaTxBase, 0)
	v, r, s := tx.RawSignatureValues()
	log.WithField("txhash", tx.Hash().String()).Info("txhash")
	log.WithField("r", common.Bytes2Hex(r.Bytes())).Info("tx r")
	log.WithField("s", common.Bytes2Hex(s.Bytes())).Info("tx s")
	log.WithField("v", common.Bytes2Hex(v.Bytes())).Info("tx v")
	rtx := &basetype.MetaTxBase{
		TxHash:   common.ToHash(tx.Hash().Bytes()),
		TxType:   1,
		ChainId:  common.FromBigInt(big.NewInt(100)),
		Gas:      tx.Gas(),
		GasPrice: common.FromBigInt(tx.GasPrice()),
		Value:    common.FromBigInt(tx.Value()),
		Data:     tx.Data(),
		Nonce:    tx.Nonce(),
		To:       common.FromEthAddress(tx.To()),
		R:        common.FromBigInt(r),
		S:        common.FromBigInt(s),
		V:        common.FromBigInt(v),
	}
	req.RawTx = append(req.RawTx, rtx)
	res, err := crypterclient.BatchRecoverTx(context.Background(), req, grpc.EmptyCallOption{})
	if err != nil {
		log.Error("batch recover tx failed", err)
	}
	log.Info("recover got from ", res.RecoverdTx[0].From)

}

func main() {
	xecc.XeccInstance()
	lis, err := net.Listen("tcp", ":38001")
	if err != nil {
		fmt.Printf("failed to listen: %v", err)
		return
	}
	s := grpc.NewServer()
	service.RegisterCrypter(s)
	go test()

	err = s.Serve(lis)
	if err != nil {
		fmt.Printf("failed to serve: %v", err)
		return
	}
}
