package service

import (
	"context"
	"encoding/hex"
	"github.com/CaduceusMetaverseProtocol/MetaCryptor/common"
	"github.com/CaduceusMetaverseProtocol/MetaCryptor/common/log"
	metatypes "github.com/CaduceusMetaverseProtocol/MetaTypes/types"
	"math/big"

	"github.com/CaduceusMetaverseProtocol/MetaCryptor/crypto"
	metacrypter "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/crypter/v1"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

type CrypterServer struct {
	metacrypter.UnimplementedCrypterServiceServer
}

func (*CrypterServer) BatchSign(ctx context.Context, req *metacrypter.BatchSignRequest) (*metacrypter.BatchSignResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchSign not implemented")
}
func (*CrypterServer) BatchVerify(ctx context.Context, req *metacrypter.BatchVerifyRequest) (*metacrypter.BatchVerifyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchVerify not implemented")
}
func (*CrypterServer) BatchRecover(ctx context.Context, req *metacrypter.BatchRecoverRequest) (*metacrypter.BatchRecoverResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchRecover not implemented")
}

func (*CrypterServer) BatchRecoverTx(ctx context.Context, req *metacrypter.BatchRecoverTxRequest) (*metacrypter.BatchRecoverTxResponse, error) {
	//tasks := make([]*XTaskSecp256k1RPubkey, len(req.RawTx))
	//big8 := big.NewInt(8)
	log.Info("server get batch recover tx request")
	froms := make([][]byte, len(req.RawTx))
	for i, tx := range req.RawTx {
		log.WithField("txhash", tx.TxHash.String()).Info("txhash")
		log.WithField("r", tx.R.String()).Info("tx r")
		log.WithField("s", tx.S.String()).Info("tx s")
		log.WithField("v", tx.V.String()).Info("tx v")
		log.WithField("chainid", tx.ChainId.String()).Info("tx chainid")

		V := common.ToBigInt(tx.V)
		chainid := common.ToBigInt(tx.ChainId)
		chainIdMul := new(big.Int).Mul(chainid, big.NewInt(2))
		v := new(big.Int).Sub(V, chainIdMul)
		vb := byte(v.Uint64() - 35)
		log.WithField("vb is ", vb).Info("vb")
		signature := make([]byte, 65)
		copy(signature[:32], common.LeftPadBytes(tx.R.Bytes(), 32))
		copy(signature[32:64], common.LeftPadBytes(tx.S.Bytes(), 32))
		signature[64] = vb
		pubk, err := crypto.RecoverPubkey(common.LeftPadBytes(crypto.SignedHash(tx, chainid), 32), signature)
		if err != nil {
			log.Info("recover failed for tx", "index", i, "err", err)
		} else {
			froms[i] = common.CopyBytes(crypto.Keccak256(pubk[1:])[12:])
			log.Info("recover address is ", hex.EncodeToString(froms[i]))
		}
		//task := &XTaskSecp256k1RPubkey{
		//	Msg:  tx.TxHash.Hash,
		//	Rsig: crypto.BytesCombine(common.LeftPadBytes(tx.R.Data, 32), common.LeftPadBytes(tx.S.Data, 32), []byte{vb}),
		//}
		//tasks[i] = task
	}
	response := new(metacrypter.BatchRecoverTxResponse)
	response.RecoverdTx = req.RawTx
	//resps, err := xecc.XeccInstance().BatchSecp256k1RecoverPubkey(tasks)
	//if err != nil {
	//	return response, err
	//}

	for i := 0; i < len(response.RecoverdTx); i++ {
		a := metatypes.BytesToAddress(froms[i])
		response.RecoverdTx[i].From = &a
	}

	return response, nil
}

func RegisterCrypter(server *grpc.Server) {
	metacrypter.RegisterCrypterServiceServer(server, &CrypterServer{})
}
