package types

import (
	"math/big"
)

var (
	zero = big.NewInt(0)
)

type BigInt struct {
	big.Int
}

func NewBigInt(v int64) *BigInt {
	return &BigInt{*big.NewInt(v)}
}
func (b BigInt) GetInt() *big.Int {
	return &b.Int
}

func (b BigInt) Marshal() ([]byte, error) {
	return b.Bytes(), nil
}

func (b *BigInt) MarshalTo(data []byte) (n int, err error) {
	var d = b.Bytes()

	if len(d) > len(data) {
		copy(data, d[:len(data)])
		return len(data), nil
	} else {
		copy(data, d)
		return len(d), nil
	}
}

func (b *BigInt) Unmarshal(data []byte) error {
	b.Int.SetBytes(data)
	return nil
}

func (b *BigInt) Size() int {
	return len(b.Int.Bytes())
}

func (b BigInt) MarshalJSON() ([]byte, error) {
	return []byte(b.Text(10)), nil
}

func (b *BigInt) UnmarshalJSON(data []byte) error {
	b.SetBytes(data)
	return nil
}

// only required if the compare option is set
func (b BigInt) Compare(other BigInt) int {
	return b.Int.Cmp(&other.Int)
}

// only required if the equal option is set
func (b BigInt) Equal(other BigInt) bool {
	return b.Int.Cmp(&other.Int) == 0
}

// only required if populate option is set
// func NewPopulatedT(r randyThetest) *T {}

type randy interface {
	Intn(n int) int
}

func NewPopulatedBigInt(r randy) *BigInt {
	data := make([]byte, 32)
	for i := 0; i < 32; i++ {
		data[i] = byte(r.Intn(255))
	}
	b := new(BigInt)
	b.Unmarshal(data)
	return b
}
