package types

import (
	"fmt"
	"math/big"
	"testing"
)

func TestBigInt(t *testing.T) {
	b1000 := big.NewInt(1000)
	m := b1000.Bytes()

	a := Hash{}
	fmt.Printf("init a is %s\n", a.Add(a.GetInt(), big.NewInt(10)))
	a.Unmarshal(m)
	fmt.Printf("after unmarshal a is %s\n", a.String())
	// l, err := a.MarshalTo(m)
	// fmt.Printf("marshal to l=%v,err=%v\n", l, err)
	// fmt.Printf("after marshal to a = %s\n", a.String())
	b := new(Hash)
	d, err := a.Marshal()
	if err != nil {
		fmt.Printf("marshal a get err=%s\n", err)
	}
	err = b.Unmarshal(d)
	if err != nil {
		fmt.Printf("unmarshal b get err=%s\n", err)
	}
	fmt.Printf("b is %s\n", b.String())
	fmt.Printf("compare a and b = %v\n", a.Compare(*b))
}
