package main

import (
	"ChainGrpcTest/log"
	"ChainGrpcTest/tool"
	"github.com/spf13/cobra"
	"os"
	"runtime/pprof"
)

var (
	initAcc, initCmp, batchSign, batchRecover, batchRecoverTx, batchVerify bool
	txCount, goRoutineCount, cmpAmount                                     int
	cpuProfile                                                             string
	cfg                                                                    *tool.Config
)

func init() {
	initCmd.PersistentFlags().IntVar(&cmpAmount, "cmp", 1, "Transfer amount,default: 1CMP")
	initCmd.PersistentFlags().BoolVar(&initAcc, "initAcc", false, "Start after initializing the account")
	initCmd.PersistentFlags().BoolVar(&initCmp, "initCmp", false, "Start after initializing the account cmp balance")
	startCmd.PersistentFlags().StringVar(&cpuProfile, "cpuProfile", "cpuProfile.prof", "Statistics cpu profile")
	startCmd.PersistentFlags().BoolVar(&batchSign, "batchSign", false, "test grpc interface -> batchSign")
	startCmd.PersistentFlags().BoolVar(&batchRecover, "batchRecover", false, "test grpc interface -> batchRecover")
	startCmd.PersistentFlags().BoolVar(&batchRecoverTx, "batchRecoverTx", false, "test grpc interface -> batchRecoverTx")
	startCmd.PersistentFlags().BoolVar(&batchVerify, "batchVerify", false, "test grpc interface -> batchVerify")
	startCmd.PersistentFlags().IntVar(&txCount, "txCount", 1000, "send tran count")
	startCmd.PersistentFlags().IntVar(&goRoutineCount, "goRoutineCount", 100, "send tran engagement count")
	startCmd.AddCommand(initCmd)
}

func main() {
	log.InitLog(log.LogConfig{Path: "logs", Level: "debug", Save: 3})
	// 执行初始化账户操作
	Execute()
}

func Execute() {
	if err := startCmd.Execute(); err != nil {
		log.Errorf("Program execute error: %s", err)
		os.Exit(1)
	}
}

var initCmd = &cobra.Command{
	Use:   "init",
	Short: "Init your account command and transfer coin",
	Run: func(cmd *cobra.Command, args []string) {
		if initAcc {
			tool.InitAccount(cfg, cfg.Count)
		}
		if initCmp {
			tool.TransferAccount(cfg, int64(cfg.Count))
		}
	},
}

var startCmd = &cobra.Command{
	Use:   "start",
	Short: "Start the stress test project",
	Run: func(cmd *cobra.Command, args []string) {
		f, err := os.Create(cpuProfile)
		if err != nil {
			log.Fatal(err)
		}
		err = pprof.StartCPUProfile(f)
		if err != nil {
			log.Error("Start cpu profile err:", err)
			return
		}
		startTest()
		defer pprof.StopCPUProfile()
	},
}
